/* ----------------------------------------------------------------- */
/* Eyebot PSD-demo by Klaus Schmitt  (k_schmit@informatik.uni-kl.de) */
/*                                                 changes: 09/05/97 */
/*                    Thomas Braunl, adapt V3 last changes: 28/02/00 */
/* ----------------------------------------------------------------- */
/* This demo shows the use of the PSD for a single shot!             */
/* ----------------------------------------------------------------- */


#include "eyebot.h"

int main ()
{
	char		z;
	PSDHandle	psd_handle;

	/* write message */
	LCDPrintf("    PSD-Demo    ");
	LCDPrintf("----------------");
	LCDPrintf("by Klaus Schmitt");

	/* Init the FRONT-PSD */
	psd_handle = PSDInit(PSD_FRONT);
	if(psd_handle == 0)
	{
		LCDPrintf("\nPSDInit Error!\n");
		OSWait(200);
		return 1;
	}

	LCDMenu("SHOT","","","END");
	
	while (1==1)
	{
		z = KEYRead();
		switch (z)
		{
			case KEY1:
				/* Start PSD-measuring for single shot */
				if(PSDStart(psd_handle, FALSE))
					LCDPrintf("\nPSD busy!\n");

				/* wait for the result */
				while(!PSDCheck()){};

				/* print timestamp, distance, raw-value */
				LCDSetPos(4,0);
				LCDPrintf("T: %5d\nD: %3d R: %3d", PSDGet(0), PSDGet(psd_handle), PSDGetRaw(psd_handle));
				break;

			case KEY4:
				/* release the used PSDs */
				PSDRelease();
				return 1;	
			
			default:
				break;

		}
	}

	return 0;
}

