/* ----------------------------------------------------------------- */
/* Eyebot Sounddemo by Klaus Schmitt (k_schmit@informatik.uni-kl.de) */
/*                                            last changes: 03/19/97 */
/* ----------------------------------------------------------------- */
/* Functions:                                                        */
/* int AU_Play_Sample(char* sample);        | plays Sample-File      */
/* int AU_Check_Sample();                   | checks for sampleend   */
/* int AU_Tone(long freq, long dur);        | plays tone for x msecs */
/* int AU_Check_Tone();                     | checks for toneend     */
/* int AU_Beep();                           | system-Beep            */
/* ----------------------------------------------------------------- */
/* Sampleformat: WAV or AU/SND  (8bit, pwm or mulaw)                 */
/* Samplerate:   5461, 6553, 8192, 10922, 16384, 32768 (Hz)          */
/* Tonerange:    65 Hz to 21000 Hz                                   */
/* Tonelength:   1 msec to 65535 msecs                               */
/* ----------------------------------------------------------------- */
/* Format of a AU/SND sample:                                        */
/* Header:                                                           */
/*      magic.l    =  ".snd"  : Identification                       */
/*      offset.l   =  #28.l   : offset to sampledata from start      */
/*      length.l              : length of sampledata (without header)*/
/*      mode.l     =  #02.l   : pwm-mode                             */
/*      freq.l                : samplefrequency of buffer            */
/*      chcount.l  =  #01.l   : channelcount (mono)                  */
/*      info.l     =  "EYE",0 : infotext                             */
/* Data:                                                             */
/*      BYTE[length] sample   : unsigned chars                       */
/* ----------------------------------------------------------------- */

#include <stdlib.h>
#include "eyebot.h"

void recorddemo()
{
    char    z;
    BYTE* buffer = (BYTE*) malloc(33000);

	LCDMenu("Live","Rec","Play","END");
	LCDPrintf("MicrophoneDemos:\n");

	while (1==1)
	{
		z = KEYRead();
		switch (z)
		{
		        case KEY1:
			  /* Sample Microphone repeatetively with delay */
			  /* and print this value on the display        */
                	  LCDMenu("","","","STOP");
                          LCDSetString ( 2,0,"Volume: ");
			  while(KEYRead() != KEY4)
			  {
                        	  LCDSetString ( 2,0,"Micro:       ");
			          LCDSetPos(2,7);
			          LCDPrintf("%d\n",AUCaptureMic());
                        	  OSWait(20);
                    	  }
                	  LCDClear();
                	  LCDMenu("Live","Rec","Play","END");
                	  LCDPrintf("MicrophoneDemos:\n");
			break;

			case KEY2:
			  /* Record 11Khz sample with Micro (3secs)    */
			  /* The sample is stored in the AU/SND format */
                          LCDSetString ( 2,0,"Recording!");
		          AURecordSample(buffer, 33000, 11000);
			  while(!AUCheckRecord()){}
                          LCDSetString ( 2,0,"          ");	
    			break;

			case KEY3:
			  /* Replay the hole recorded sample          */
                          LCDSetString ( 2,0,"Playing!");
                	  AUPlaySample(buffer);
			  while(!AUCheckSample()){}
                          LCDSetString ( 2,0,"        ");
			break;

			case KEY4:
			  free(buffer);
			  return;
			break;	
			
			default: break;
		}
	}
	return;
}

int main (void)
{
        extern	BYTE SAM_Ready[];	/* Voice says "Ready" sample */
	char    z;

  /* write message */
	LCDPrintf("   Audio-Demo   \n");
	LCDPrintf("----------------\n");
	LCDPrintf("by Klaus Schmitt\n");
	LCDMenu("Tone","Mic","WAV","END");
	
	while (1)
	{
		z = KEYRead();
		switch (z)
		{
		  case KEY1:
                    /* Play a 1000 Hz tone for 500 msecs and wait */
            	    /* until the tone is played to the end        */
                    AUTone(1000,500);
                    while(!AUCheckTone()){};
           	  break;

 		  case KEY2:
            	    /* Play just the simple system-beep */
                    /* and switch to other menue        */
                    AUBeep();
                    recorddemo();	
                    LCDClear();
               	    LCDPrintf("   Audio-Demo   \n");
            	    LCDPrintf("----------------\n");
            	    LCDPrintf("by Klaus Schmitt\n");
            	    LCDMenu("Tone","Mic","WAV","END");
		  break;

                  /* Play a short sample and wait for it's end */
	          case KEY3:
                    if(AUPlaySample(SAM_Ready))
                    while(!AUCheckSample());
                    else
                    {
                      LCDClear();
                      LCDPrintf("ERROR!\n");
                      LCDPrintf("Sample: format?\n");
                      return 0;
                    }
		  break;

		  case KEY4:
            	    return 0;	
			
		  default: break;

		}
	}
return 0;
}

