/******************************************************************** 

 * Inclino.h 

 * Specification of inclinometer functions and global variables

 *

 * Authors: NE Stamatiou & CM Smith

 * Blizzard Project 2002

 *

 *******************************************************************/



#ifndef INCLINO_H

#define INCLINO_H



#include <stdlib.h>

#include <stdio.h>

#include "eyebot.h"

#include <string.h>

#include <math.h>



/*Maximum number of samples to be taken */

#define MAX_SAMPLES 5000



/*inclinometer scaling factors*/

#define IAVE_SCALE 		0.995

#define IANGLE_SCALE 	0.66



/*Data Logging globals */

int iraw[MAX_SAMPLES];

int itime[MAX_SAMPLES];

int imin[MAX_SAMPLES];

int imax[MAX_SAMPLES];

int iaverage[MAX_SAMPLES];

int imaverage[MAX_SAMPLES];

int iangle[MAX_SAMPLES];



/*Logging of data stability monitoring values - no longer used */

//int inext[MAX_SAMPLES];

//int icurrent[MAX_SAMPLES];

//int ilast[MAX_SAMPLES];



/*Stored Calibration data */

int initdat[10];



/*Number of samples taken from Inclinometer*/

int isamples;



/*Inclinometer Stability values */

int StableVal, StableNum;



/*Inclinometer Functions*/

void InitInclino(void);

void GetInclinoData(void);

double GetIAngle(void);



#endif

