/* sim.h - Definitions of gyro functions and globals */



#ifndef SIM_H

#define SIM_H



#include <stdlib.h>

#include <stdio.h>

#include <string.h>

#include <math.h>



#define MAX_SAMPLES 30000



#define UP_SCALE   0.8333

#define DOWN_SCALE 1.2 //0.8620



#define UPPER_BOUND 250

#define LOWER_BOUND -250



//#define MIN_SCALE 0.9963	//0.9963

//#define MAX_SCALE 1.0034	//1.0034



//#define MIN_SCALE 0.99987

//#define MAX_SCALE 1.00023



#define MIN_SCALE 0.9955	//0.9963

#define MAX_SCALE 1.0034



#define MIN_LIMIT  0.99985

#define MAX_LIMIT  1.00015



/*Gyroscope noise reduction constants*/

#define NOISE_HIGH 1.015

#define NOISE_LOW 0.989

#define NOISE_SCALE 1.7



#define ANGLE_SCALE -0.0017    	//-0.0013

//#define ANGLE_SCALE -0.00072 /*Factor to convert the int angle stored for gyro to real angle */



#define AVERAGE_SIZE  4



/*Logging Arrays */

int graw[MAX_SAMPLES];

int gtime[MAX_SAMPLES];

int gmin[MAX_SAMPLES];

int gmax[MAX_SAMPLES];

int gaverage[MAX_SAMPLES];

int gangle[MAX_SAMPLES];

int gmaverage[MAX_SAMPLES];

int gnorm[MAX_SAMPLES];

int hardcore[MAX_SAMPLES];

int lower[MAX_SAMPLES];

int upper[MAX_SAMPLES];

int oldAngle[MAX_SAMPLES];



/*Log Gyro initialisation variables */

int ginit[10];



int Angle,AveAngVel1;

int SampleTime;

int gsamples;

int grest;



int lower_bound;

int upper_bound;





#endif

