# include"mlp.h"

double sigmoid(double x){ return 1.0 / (1.0 + (double)exp(-x));}

void feedforward(double N_in[NIN], double N_hid[NHID], double N_out[NOUT], double w_in[NIN][NHID], double w_out[NHID][NOUT])
{ int i,j;

  /* calculate activation of hidden neurons*/
  N_in[NIN-1] = 1.0; /* set bias input neuron*/
  for (i=0; i<NHID-1; i++){
    N_hid[i] = 0.0;
    for (j=0; j<NIN; j++)
      N_hid[i] += N_in[j] * w_in[j][i];
    N_hid[i] = sigmoid(N_hid[i]);
  }
  N_hid[NHID-1] = 1.0; /* set bias hidden neuron*/
  /* calculate activation and output of output neurons*/
  for (i=0; i<NOUT; i++)
  { N_out[i] = 0.0;
    for (j=0; j<NHID; j++)
      N_out[i] += N_hid[j] * w_out[j][i];
    N_out[i] = sigmoid(N_out[i]);
  }
}

double backprop(double train_in[NIN], double train_out[NOUT],double l_rate,double w_in[NIN][NHID], double w_out[NHID][NOUT])
/* returns error for current pattern*/
{ int i,j;
  double err_p; /*error for this pattern*/
  double N_out[NOUT],err_out[NOUT];  /*/ generated network output*/
  double diff_out[NOUT];  /*/ diff output to desired*/
  double N_hid[NHID], err_hid[NHID];
  /*/re-calc network, difference and hidden output*/
  feedforward(train_in, N_hid, N_out, w_in, w_out);
  err_p = 0.0;

  /*/ calculate error of output layer*/
  for (i=0; i<NOUT; i++){
    diff_out[i] = train_out[i]-N_out[i];
    err_out[i] = (diff_out[i]) * (1.0 - N_out[i]) * N_out[i];
    err_p += (diff_out[i] * diff_out[i] * 0.5);
  }
  /*/ calculate error of hidden layer before updating w_out*/
  for (i=0;i<NHID;i++){
    err_hid[i] = 0;
    for (j=0; j<NOUT; j++){
      err_hid[i] += err_out[j] * w_out[i][j] * (1.0 - N_hid[i]) * N_hid[i];
      w_out[i][j] +=  l_rate * err_out[j] * N_hid[i]; /* output weight change */
    }
  }
  /*/ update w_in*/
  for (i=0; i<NIN; i++)
    for (j=0; j<NHID; j++)
      w_in[i][j] += l_rate * err_hid[j] * train_in[i]; /* input weight change */

  return err_p;
}

void train(int cycles,double lerning_rate,int dataset,int batch, double train_in_data[MAXPATERN][NIN], double train_out_data[MAXPATERN][NOUT],double w_in[NIN][NHID], double w_out[NHID][NOUT])
{
  int i,j,a,b;
  double bvalue,errval;

  double d_w_in [NIN][NHID];
  double d_w_out[NHID][NOUT];
  double old_w_in [NIN][NHID];
  double old_w_out[NHID][NOUT];


  for (i=0;i<cycles;i++){

    if(batch){
      /*/ save unchanged value of w in old_w*/
      /*/ make d_w 0*/
      for(a=0;a<NIN;a++)  { for(b=0;b<NHID;b++) {old_w_in[a][b] = w_in[a][b]; d_w_in[a][b]=0; }}
      for(a=0;a<NHID;a++) { for(b=0;b<NOUT;b++) {old_w_out[a][b]= w_out[a][b];d_w_out[a][b]=0;}}
    }
    errval = 0.0;
    for (j=0;j<dataset;j++){
      bvalue = backprop(train_in_data[j], train_out_data[j],lerning_rate, w_in, w_out);
      errval += bvalue;

      if(batch){
        /*/ accumulate d_w*/
        /*/ reset w to unchanged value*/
        for(a=0;a<NIN;a++)  { for(b=0;b<NHID;b++) { d_w_in[a][b] +=(old_w_in[a][b] - w_in[a][b]); w_in[a][b] =old_w_in[a][b];}}
        for(a=0;a<NHID;a++) { for(b=0;b<NOUT;b++) { d_w_out[a][b]+=(old_w_out[a][b]- w_out[a][b]);w_out[a][b]=old_w_out[a][b];}}
      }
    }

    if(batch){
      /*/ apply changes*/
      for(a=0;a<NIN;a++)  for(b=0;b<NHID;b++) w_in[a][b] = old_w_in[a][b] - d_w_in[a][b];
      for(a=0;a<NHID;a++) for(b=0;b<NOUT;b++) w_out[a][b]= old_w_out[a][b]- d_w_out[a][b];
    }

    printf("\b\b\b\b");
    printf("%3.0d%%",(i+1)*100/cycles);

  }
  printf("\n");
  errval = 0.0;
  for (j=0;j<dataset;j++){
    bvalue = backprop(train_in_data[j], train_out_data[j], 0.0, w_in, w_out);
    errval += bvalue;
  }
  printf("after %d cycles error is %f\n", i, errval);
}


void testnet(int dataset,double w_in[NIN][NHID], double w_out[NHID][NOUT], double train_in_data[MAXPATERN][NIN],double train_out_data[MAXPATERN][NOUT])
{
  double out[NOUT], hid[NHID],error=0;
  int i,j;
  for (i=0;i<dataset;i++){
    printf("\n");
    feedforward(train_in_data[i], hid, out, w_in, w_out);
    
    for (j=0;j<NOUT;j++){
      printf("%2.1f ",out[j]);
      error += (0.5*(train_out_data[i][j]-out[j])*(train_out_data[i][j]-out[j]));
    }
    printf("\n");
    for (j=0;j<NOUT;j++){
      printf("%2.1f ",train_out_data[i][j]);
    }
    printf("\n");
  }
  printf("error: %f\n",error);
}


void init_weights(double w_in[NIN][NHID], double w_out[NHID][NOUT])
{
  int i,j;
  srand((unsigned)time(NULL));
  for (i=0; i<NIN; i++)
    for (j=0; j<NHID; j++)
      w_in[i][j] = (((double)rand() / (double)RAND_MAX) );
  for (i=0; i<NHID; i++)
    for (j=0; j<NOUT; j++)
      w_out[i][j] = (((double)rand() / (double)RAND_MAX) );
}


void show_weights(double w_in[NIN][NHID], double w_out[NHID][NOUT])
{
  int i,j;
  printf("w_in:\n");
  for (i=0; i<NIN; i++){
    for (j=0; j<NHID; j++)
      printf("%3.2f ",w_in[i][j]);
    printf("\n");
  }
  printf("w_out:\n");
  for (i=0; i<NHID; i++){
    for (j=0; j<NOUT; j++)
      printf("%3.2f ",w_out[i][j]);
    printf("\n");
  }
}

