#define _GNU_SOURCE
#include <stdio.h>
#include <stdlib.h>
# include "npara.h"
# include "mlp.h"
/*
#include "num_dataset.h"
#include "in_dataset.h"
#include "out_dataset.h"
*/


/*
writes the weights of the net to file "weights.h"
in order to include it in the robot driving programm
*/
void write_weights(double w_in [NIN][NHID], double w_out[NHID][NOUT])
{
   int i,j;
   FILE *file_weights;
   char *fileNameWeights="weights.h";
   file_weights = fopen(fileNameWeights,"w");
   fprintf(file_weights,"double w_in [NIN][NHID]={\n");
   for (i=0; i<NIN; i++){
     fprintf(file_weights,"{");
     for (j=0; j<NHID; j++) {
       fprintf(file_weights,"%3.2f ",w_in[i][j]);
       if(j<NHID-1) fprintf(file_weights,", ");
     }
     fprintf(file_weights,"}");
     if(i<NIN-1) fprintf(file_weights,",\n");
   }
   fprintf(file_weights,"\n};\n");
   fprintf(file_weights,"double w_out [NHID][NOUT]={\n");
   for (i=0; i<NHID; i++){
     fprintf(file_weights,"{");
     for (j=0; j<NOUT; j++){
       fprintf(file_weights,"%3.2f ",w_out[i][j]);
       if(j<NOUT-1) fprintf(file_weights,", ");
     }
     fprintf(file_weights,"}");
     if(i<NHID-1) fprintf(file_weights,",\n");
   }
   fprintf(file_weights,"\n};\n");
   fclose(file_weights);
}

/*
writes the weights to specified file
this is needed if trainer is called several times without -i option
then the weights are readen from this file and writen after training
*/

void write__weights(char *fileNameWeights,double w_in [NIN][NHID], double w_out[NHID][NOUT])
{
   int NIN_,NHID_,NOUT_;

   FILE *file_weights;
   NIN_= NIN;
   NHID_=NHID;
   NOUT_=NOUT;
   //char *fileNameWeights="weights.h";
   file_weights = fopen(fileNameWeights,"w");
   fwrite(&NIN_,sizeof(int),1,file_weights);
   fwrite(&NHID_,sizeof(int),1,file_weights);
   fwrite(&NOUT_,sizeof(int),1,file_weights);
   fwrite(w_in,sizeof(double),(NIN_*NHID_),file_weights);
   fwrite(w_out,sizeof(double),(NHID_*NOUT_),file_weights);
   fclose(file_weights);
}

/*
reads the weights from specified file
this is needed if trainer is called several times without -i option
then the weights are readen from this file and writen to it after training
*/
void read__weights(char *fileNameWeights,double w_in [NIN][NHID], double w_out[NHID][NOUT])
{
   int NIN_,NHID_,NOUT_;

   FILE *file_weights;
   file_weights = fopen(fileNameWeights,"r");
   if(file_weights==NULL){
     printf("error opening File: %s\n",fileNameWeights);
     printf("can't find file\n");
     exit(0);
   }
   NIN_= NIN;
   NHID_=NHID;
   NOUT_=NOUT;
   fread(&NIN_,sizeof(int),1,file_weights);
   fread(&NHID_,sizeof(int),1,file_weights);
   fread(&NOUT_,sizeof(int),1,file_weights);
   if(NIN_!=NIN || NHID_!=NHID || NOUT_!=NOUT){
     printf("error opening File: %s\n",fileNameWeights);
     printf("wrong net params in file\n");
     exit(0);
   } else {
     fread(w_in,sizeof(double),(NIN_*NHID_),file_weights);
     fread(w_out,sizeof(double),(NHID_*NOUT_),file_weights);
     fclose(file_weights);
   }
}

/*
reads the trainingdata from specified file and stores it in
filestructure:

sizeof(int) BYTE number of datasets in file (X)
sizeof(int) BYTE number of input neurons (Y)
sizeof(int) BYTE number of output neurons (Z)
(X) * (sizeof(int) * (Y) + sizeof(float) * (Z)) BYTE of training data
*/
void read_data(char* fileNameData,int* anz_data,double train_in_data[MAXPATERN][NIN],double train_out_data[MAXPATERN][NOUT])
{
   int i,j,AnzData,FileData,NIN_,NOUT_,int_value;
   float float_value;


   FILE *file_data;
   file_data = fopen(fileNameData,"r");
   if(file_data==NULL){
     printf("error opening File: %s\n",fileNameData);
     printf("can't find file\n");
     exit(0);
   }
   fread(&FileData,sizeof(int),1,file_data);
   fread(&NIN_,sizeof(int),1,file_data);
   fread(&NOUT_,sizeof(int),1,file_data);
   AnzData  = *anz_data;
   for(i=AnzData;i<FileData+AnzData;i++){

     for(j=0;j<NIN_;j++){
       fread(&int_value,sizeof(int),1,file_data);
       /**/
       int_value = int_value<410?int_value:410;
       int_value = int_value>90?int_value:90;
       train_in_data[i][j]=((double)int_value-90.0)/410.0;
     }
     train_in_data[i][NIN_]=1.0; /*set bias*/

     /*read output and convert*/
     for(j=0;j<NOUT_;j++){
       fread(&float_value,sizeof(float),1,file_data);
       if(j==0){
	 float_value = float_value<0.2?float_value:0.2;
	 float_value = float_value>-0.2?float_value:-0.2;
	 float_value = (float_value+0.2)/0.4;
	 train_out_data[i][j]=float_value;
       }
       if(j==1){
	 float_value = float_value<2.0?float_value:2.0;
	 float_value = float_value>-2.0?float_value:-2.0;
	 float_value = (float_value+2.0)/4.0;
	 train_out_data[i][j]=float_value;
       }

       
     }
   }
   *anz_data = AnzData+FileData;
   fclose(file_data);
}



int main(int argc, char** argv)
{


/* Set defaults for all parameters: */
    int dataset=0;
    int Training_Cycles = 0;
    double Lerning_Rate = 0.0;
    int RW_Weights = 0;
    int Init_Weights = 0;
    int  Show_Weights = 0;
    int Test_Net = 0;
    int Batch_Learn = 0; /* 0 means direct lerning*/
    char* RWWeightsFileName=NULL;
    char* ReadDataFileName=NULL;
    double W_IN [NIN][NHID];  /* in weights*/
    double W_OUT[NHID][NOUT]; /* out weights*/
    double TRAIN_IN_DATA[MAXPATERN][NIN];
    double TRAIN_OUT_DATA[MAXPATERN][NOUT];

    int i;

    /* Start at i = 1 to skip the command name. */

    for (i = 1; i < argc; i++) {

	/* Check for a switch (leading "-"). */

	if (argv[i][0] == '-') {

	    /* Use the next character to decide what to do. */

	    switch (argv[i][1]) {
	        case 'd':       ReadDataFileName = argv[++i];
				read_data(ReadDataFileName,&dataset,TRAIN_IN_DATA, TRAIN_OUT_DATA);
				break;

		case 'c':	Training_Cycles = atoi(argv[++i]);
				break;

		case 'l':	Lerning_Rate = atof(argv[++i]);
				break;

		case 'i':	Init_Weights = 1;
				break;

		case 'w':	RW_Weights = 1;
				RWWeightsFileName = argv[++i];
				break;

		case 's':	Show_Weights = 1;
				break;

		case 'b':	Batch_Learn = 1;
		                break;

		case 't':	Test_Net = 1;
				break;

	    }
	}
    }

    printf("training for %d cycles\n", Training_Cycles);
    printf("lerning rate = %f\n", Lerning_Rate);
    if(Batch_Learn) printf("Batch Lerning\n"); else printf("Direct Lerning\n");
    printf("%d datasets\n", dataset);
    if(RW_Weights && !Init_Weights){
      read__weights(RWWeightsFileName,W_IN,W_OUT);
      if (Show_Weights){
        printf("-------------------weights from file---------------------:\n");
        show_weights(W_IN,W_OUT);
      }
    }
    else{
      init_weights(W_IN,W_OUT);
      if (Show_Weights){
        printf("----------------------init weights-----------------------:\n");
        show_weights(W_IN,W_OUT);
      }
    }
    train(Training_Cycles,Lerning_Rate,dataset,Batch_Learn,TRAIN_IN_DATA,TRAIN_OUT_DATA,W_IN,W_OUT);

    if (Show_Weights) {
      printf("-----------------weights after training------------------:\n");
      show_weights(W_IN,W_OUT);
    }
    if (RW_Weights) {
      write__weights(RWWeightsFileName,W_IN,W_OUT);
      write_weights(W_IN,W_OUT);
    }
    if(Test_Net) testnet(dataset,W_IN,W_OUT,TRAIN_IN_DATA,TRAIN_OUT_DATA);
    return 1;
}
