/**
 * A 3-5-2 backpropagation network
 */

#ifndef BACKPROP_352_H
#define BACKPROP_352_H

#define IN_SIZE  3			// network input layer size
#define HID_SIZE 5			// network hidden layer size
#define OUT_SIZE 2			// network output layer size

#define LEARNING_RATE 0.1		// network learning rate (use small number
					// for more stable training, but longer
					// training time. Use number near 1 for
					// faster training, but network may not converge.

/* GLOBAL DATA FOR NETWORK */
FLOAT x1[IN_SIZE];
FLOAT W1[HID_SIZE][IN_SIZE];
FLOAT y1[HID_SIZE];
FLOAT g1[HID_SIZE];

FLOAT x2[HID_SIZE];
FLOAT W2[OUT_SIZE][HID_SIZE];
FLOAT y2[OUT_SIZE];
FLOAT g2[OUT_SIZE];

// Create both layers.  Note that this intializes the layers
// with references to the memory allocated above.
layer_t layers[2] =	{
	{IN_SIZE,HID_SIZE,x1,&W1[0][0],y1,g1},
	{HID_SIZE,OUT_SIZE,x2,&W2[0][0],y2,g2}
};

// Create the network and initialize with the layers previously
// allocated.
network_t network = {2,LEARNING_RATE,layers};

#endif //BACKPROP_352_H

