#ifndef AUTOPILOT_H
#define AUTOPILOT_H
/****************************************************************************
autopilot.h - Created by Peter Mauger 03/04/01
last modified 11/09/01

autopilot contains the functions required to manipulate the aircraft. For Exp 1
will only contain functions for the rudder, to indicate an error using an
external light, and to check the autopilot switch.
****************************************************************************/

#include "include.h"

/* Wait_For_Switch waits for manual<->autopilot switch to see if eyebot should 
* take/relinquish control. When change occurs, resumes control
*inputs:   setting->switch setting to wait for
*/
void Wait_For_Switch(switchstate setting);

/* Indicate_Error indicates error using external light 2. Will flash errornum times then 
*leave light on.
*inputs:   error_type->error type (error) 
*          error_stage->the stage in the program that the error occured (FLIGHT or INITIALISE)   
*	   plane->plane information
*returns:  TRUE if error is recoverable
*	   FALSE if no error occured
*/
bool Indicate_Error(error error_type, errorstage error_stage, planestate *plane);

/* Returns aircraft to level flight, and centres rudder (shouldnt have to worry
*about leveling aircraft for Exp 1)
* inputs:  plane->contains plane state information
* returns: an error if a problem has occured
*	   NOERROR otherwise
*/
error Fly_Straight(planestate *plane);

/* Brings aircraft into left turn (only using rudder in Exp 1)
* inputs:  plane->contains plane state information
* returns: an error if a problem has occured
*	   NOERROR otherwise
*/
error Turn_Left(planestate *plane);

/* Brings aircraft into right turn (only using rudder in Exp 1)
* inputs:  plane->contains plane state information
* returns: an error if a problem has occured
*	   NOERROR otherwise
*/
error Turn_Right(planestate *plane);

#endif
