#ifndef COMPASS_H
#define COMPASS_H
/****************************************************************************
Created by Peter Mauger 03/04/01
Last Modified 20/09/01

compass contains all the functions required to initialise, test, and retrieve
data from the 2D vector compass which will be connected to the eyebot.
****************************************************************************/
#include "include.h"

/* Init_Compass initialises the 2D vector compass for operation
* returns: FALSE if the initialisation failed
*	   TRUE if it was successful
*/
bool Init_Compass();

/* Obtain_Heading stores the current output of the compass in the plane 
* structure
* inputs:  plane->contains the plane state information
* returns: FALSE if the bearing was not within 0 to 360 degrees
*	   TRUE otherwise
*/
bool Obtain_Heading(planestate *plane);	

/* Test_Sensors is a data logging function which logs the current sensor 

* information
* inputs:  plane->contains the positional data
*/
void Test_Sensors(planestate *plane);

/* Calibrate_Compass performs the calibration of the vector compass so that it
* is aligned south->north at 0 degress
* returns: FALSE if the calibration was cancelled (data is cleared, should recalibrate)
*	   TRUE if the calibration was successful
*/
bool Calibrate_Compass();

#endif
