/*****************************************************************************
Experiment1.c - Created by Peter Mauger 03/04/01
Last modified 09/09/01

Experiment1 is the main program which will perform experiment 1 of the Automated
Flight Group's project 2001. Experiment 1 will involve logging data to a temporary
memory location for downloading at a later time. Its purpose is to determine that
the hardware is functioning correctly for the duration of a flight before 
experiment 2 is performed.
*****************************************************************************/

#include "include.h"
 
planestate plane;

void Periodic_Logger(void)		/* Interrupt function which calls the data logger */
{
	LCDSetPrintf(0,0,"%f\n%f\n",(float)Get_Latitude(Get_Curr_Pos(plane)),(float)Get_Longitude(Get_Curr_Pos(plane)));
	Log_Event(&plane, LOGPOSITION);
}

int main(){

        TimerHandle logger;
	int total_num_wps = 0, key =0;
        bool valid = FALSE;
	error error_type = NOERROR;
        programstate cont = TERMINATE;
	switchstate last_switch = UNDEFINED, new_switch = UNDEFINED;
	
        error_type = Initialise_Plane(&plane);      		/*This function will contain all the*/
        if(error_type != NOERROR)              			/*required functions to initialise the*/
        {                                        		/*aircraft and its components. Establish*/
                valid = Indicate_Error(error_type, INITIALISE, &plane);	/*current pos and bearing*/
        }                                        		/*and desired turn = STRAIGHT*/
		
	if(valid == TRUE) 		/* Of an error occured shut down the plane and return */
	{
	        Shut_Down(plane);
	        return 1;
	}
	total_num_wps = Get_Wplist_Total(Get_Wplist(plane));
	LCDPrintf("Initialisation\nComplete\n%d waypoints\n", total_num_wps);
	OSWait(LONG);
	LCDClear();
	
	cont = Start_Menu(&plane);
	if(cont == TERMINATE) 
	{
	        Shut_Down(plane);	/* If the result was to terminate, shut down the plane and return */
		return 0;
	}
	LCDClear();
	logger = OSAttachTimer( 100, Periodic_Logger );		/* Begin the periodic logger timer */
	if(logger == 0)
	{
		Shut_Down(plane);
		LCDPrintf("bad timer handle\n");
		return 1;
	}
	LCDMenu("STOP","","","END");
	while(cont!=TERMINATE)		/* Call up the menu when not terminating */
	{
		new_switch = Check_Switch();
		if(new_switch != last_switch)
		{
			last_switch = new_switch;
			LCDSetPrintf(2,0,"switch %d ",new_switch);
			if(new_switch == OFF) Log_Event(&plane, SWITCHMANUAL);
			else if(new_switch == ON) Log_Event(&plane, SWITCHAUTO);
			else Log_Event(&plane, SWITCHDETECT);
		}
	
		Test_Sensors(&plane);
		
		key = 0;
		
		key = Check_Input();
		switch(key)
		{
			case KEY1:		/* Download data */
				OSDetachTimer(logger);
				Download_Menu(&plane);
				cont = TERMINATE;
				break;
			case KEY4:		/* End logging (must confirm) */
				cont = Confirmation_Menu();
				LCDClear();
				LCDMenu("STOP","","","END");
				break;
			default:
				cont = GO;
		}
	}
	
	OSDetachTimer(logger);
	Shut_Down(plane);
	return 0;
}










