#ifndef MENU_H
#define MENU_H

/******************************************************************************
menu.h - Created by Peter Mauger 25/07/01
Last Modified 09/09/01

menu provides the Startup menu functions. The menu will provide the ability to
modify servo limits, download a new set of waypoints, check the values of the
GPS and compass, and possibly some other functions.
******************************************************************************/
#include "include.h"

/* Start_Menu is the function which initialises the menu system for the aircraft
* before takeoff. When it returns the plane will be ready for automatic flight,
* only waiting for the autopilot to be activated by the pilot.
* inputs:  plane->contains the required structures and data
* returns: GO if the plane is ready to go
*	   TERMINATE if the program is to be terminated
*/
programstate Start_Menu(planestate *plane);

/* Set_Menu provides further sub-menues to set servos, the compass, or upload new 
* waypoints.
* inputs:  plane->control struct contains the servo handles
*/
void Set_Menu(planestate *plane);

/* Servo_Set_Menu provides the ability to set the limits and neutral points of
*all of the servos controlled by the eyebot.
*inputs:  plane->control struct contains the servo handles
*/
void Servo_Set_Menu(planestate *plane);

/* Compass_Set_Menu allows the compass to be reinitialised (if it is incorrectly
* aligned)
*/
void Compass_Set_Menu();

/* Upload_Waypoints_Menu allows the user to overwrite the old set of waypoints
*with a new set.
*inputs:  plane->position struct contains the waypoint list
*/
void Upload_Waypoints_Menu(planestate *plane);

/* Sensor_Menu allows the user to read the values of the two sensors used, the
*GPS and the compass.
*inputs:  plane->plane struct required to obtain GPS position
*/
void Sensor_Menu(planestate *plane);

/* Test_Menu allows the user to read the values of the two sensors used, the
* GPS and the compass.
* inputs:  plane->plane struct required to obtain GPS position
*/
void Test_Menu(planestate *plane);

/* Flight_Menu is the menu that will be available while the flight algorithm is
* underway. It allows the algorithm to be stopped (probably won't be able to 
* restart from here)
* inputs:  plane->contains all the data recorded during flight
* returns: GO->continue the flight
*	   TERMINATE->finish the program
*/
programstate Flight_Menu(planestate *plane);

/* Download_Menu allows the user to download the error log before terminating 
* the program.
* inputs:  plane->contains the error log
*/
void Download_Menu( planestate *plane );

/* Confirmation_Menu is used when you want to confirm that the user wants to exit
* the program
* returns: TERMINATE if they confirm exit
*	   GO if they say they don't want to exit
*/ 
programstate Confirmation_Menu(void);

#endif
