#ifndef POSITION_H
#define POSITION_H
/*******************************************************************************
position.h - Created by Peter Mauger 30/07/01
Last Modified 12/10/01

position contains all functions required to manipulate the p_pos structure.
It should be noted that all latitudes and longitudes are stored in the form
	dddmm.mmmmmm - where d represents the degrees values of the number
		       and m represents the minutes values of the number
A function (Convert_GPS2deg) has been provided to convert these values into degrees
only (ie to ddd.ddddddddd).		       
*******************************************************************************/

#include "include.h"

/* Init_Pos initialises the internal variables of the position struct
* returns: initialised position
*/
position Init_Pos();

/* Get_Latitude retrieves the latitudinal component of the position
* inputs:  pos->position (contains latitude info)
* returns: latitude as double (+ve -> North, -ve -> South)
*/
double Get_Latitude(position pos);

/* Set_Latitude sets the latitudinal component of the position
* inputs:  pos->position (contains latitude info)
*	   latitude->the latitude to be stored (double)
*	   	     (+ve -> North, -ve -> South)
*/
void Set_Latitude(position *pos, double latitude);

/* Get_Longitude retrieves the longtitudinal component of the position
* inputs:  pos->position (contains longitude info)
* returns: longitude as double (+ve -> East, -ve -> West)
*/
double Get_Longitude(position pos);

/* Set_Longitude sets the longitudinal component of the position
* inputs:  pos->position (contains longitude info)
*	   longitude->the longitude to be stored (double)
*		      (+ve -> East, -ve -> West)
*/
void Set_Longitude(position *pos, double longitude);

/* Calc_Distance calculates the distance in metres between two navigational points
* (lat, long) 
* inputs:  p1->first point   
*	   p2->second point   
* returns: distance in metres {but not quite! There is some error here...})
*/
double Calc_Distance(position p1, position p2, double *dist);

/* Calc_Bearing calculates the bearing required to reach the waypoint from
* the GPS position (Adaptation of Russell Rodgers function CEarth::direction)
* inputs:  plane->plane information (contains current position and waypoint)  
* returns: Bearing in degrees from GPSpos to WPpos
*/
double Calc_Bearing(planestate plane);

/* Calc_Correction calculates the heading correction required to reach the waypoint 
* given the current heading
* inputs:   plane->plane information   
*	    br->bearing required to reach wp (degrees 0->360)
* returns:  Correction in degrees from curr_heading to WP_bearing (degrees (+ve->left)(-ve->right))
*/
double Calc_Correction(planestate plane, double bearing_req);

/* Convert_GPS2deg takes a GPS latitude or longitude (dddmm.mmmmmm where d is a degree value and m
* is a minute value) and converts it to degrees only (ddd.ddddddddd where d is a degree value)
* inputs:  gps_angle->the latitude/longitude value to be converted
* returns: the angle in degrees value only
*/
double Convert_GPS2deg(double gps_angle);

/* Convert_deg2rad converts a number in degrees to a number in radians 
* (Function provided by Russell Rodgers)
* inputs:  deg->value in degrees
* returns: deg as radians
*/
double Convert_deg2rad(double deg);

/* Convert_deg2rad converts a number in radians to a number in degrees 
* (Function provided by Russell Rodgers)
* inputs:  rad->value in radian
* returns: rad as degrees
*/
double Convert_rad2deg(double rad);

#endif
