#include "eyebot.h"

/** Handle for motors */
VWHandle vw;

/** values for RoBIOS PI controller (used in vw interface) */
#define v_lin 7.0
#define t_lin 0.3
#define v_rot 10.0
#define t_rot 0.1
 
void main()
{
  if (!(vw = VWInit(VW_DRIVE, 1)))	/* initialize motors and encoders */
    LCDPutString("VWInit error!\n");

	if (VWStartControl(vw, v_lin, t_lin , v_rot, t_rot) == -1)
		LCDPutString("VWStart error!\n");

	KEYWait(ANYKEY);
	VWDriveCurve(vw, 0.07, 0.37, 1.0);

	KEYWait(ANYKEY);
	VWDriveCurve(vw, 0.16, 0.37, 1.0);

	KEYWait(ANYKEY);
	VWDriveCurve(vw, 0.2, -0.19, 1.0);
	VWDriveWait(vw);

  VWRelease(vw);
}
