/***********************************************************************/
/** @name global.h   
    Contains all global definitions and variables.

    @author Thomas Braunl & Birgit Graf, UWA, 1998, modified 2000 (Mk3/4)

*/
/***********************************************************************/

/*@{*/

#include "eyebot.h"
#include <math.h>


/* -----------= directions =-------------- */

#ifndef RIGHT
#define RIGHT 1
#endif

#ifndef LEFT
#define LEFT -1
#endif

#define MIDDLE 0
#define FRONT 0			/* for PSD */

/* #define UP 1	*/		/* for camera servo */
/* #define DOWN 2 */



/* -----------= constant factors =-------------- */

#ifndef PI
#define PI M_PI
#endif
#define PI2 M_PI/2		/* PI half */

#define SSIZE 8192		/* stack for parallel processing */

#define LENGTH 2.740		/* field length (in m) */
#define LENGTH2 1.370		/* field length (in m) */
#define LENGTH4 0.685		/* quarter field length (in m) */
#define WIDTH2 0.7625		/* half field width (in m) */
#define WIDTH4 0.38125		/* quarter field width (in m) */

#define GOALWIDTH 0.5		/* goal width (in m) */
#define ROBWIDTH2 0.04		/* half robot width (in m) */


/** distance when ball is caught. Goalie: start kicking */
#define GOT_BALL 0.05


/* -----------= global flags =-------------- */
/** flag to indicate whether audio is used */
#define USE_AUDIO TRUE


/** flag to indicate current camera position, set after
    camera movement */
extern int cam_pos;  

/* ----= flags to indicate results of sensor readings  =---- */
/** flag to indicate keypress (-> end ball search) */
extern int end_flag;

/** flag to indicate detected object */
extern int obstacle_flag;

/** flag to indicate having ball caught in front of robot */
extern int got_ball_flag;

/** flag to indicate seeing ball */
extern int see_ball_flag;	

/** flag to indicate that program just started */
extern int start_flag;
extern int start_flag1;
extern int attack_flag ;

/** flag for competition mode */
extern int competition_mode;		
  
/** position of player */
extern int player_pos;

/** home position of different players */
extern PositionType home[4][3];

/** next home position */
extern int next_home;


/*@}*/
