/***********************************************************************/
/** @name imageglobal.h 
    @author Birgit Graf, UWA, 1998, modified 2000 (Mk3/4)
*/
/***********************************************************************/

/*@{*/


#include "global.h"

#define NO_HUE 255

/* -----------= colours =-------------- */
#define BLACK  0
#define WHITE 15


/** size at bottom of ball (where it should be detected) */
#define BALLSIZE 0.03


/**
   Init camera.
 */
void Init_Cam();

/** Change camera parameters.
    Changes brightness, hue and saturation in case default values
    aren't good enough (e.g. different light conditions). Function as
    in RoBiOS-Setup, but without camera-initialisation, works only for
    colour-camera.
 */
void set_cam_parameters();

/** Change parameters.
    Changes thresholds which are used to select ball/goal coloured
    pixels from others and size of ball/goal.
 */
void set_img_parameters();

/** Set Ball colour.
    Set ball colour to colour detected in middle of picture
    (mean value of 5x5 area around middle of picture).
 */
void set_ball_colour(colimage img);

/** Set Goal colour.
    Set goal colour to colour detected in middle of picture
    (mean value of 5x5 area around middle of picture).
 */
void set_goal_colour(colimage img);

/** Mark object.
    Convert colour picture into greyscale (for LCD output),
    mark goal position by drawing a vertical and horizontal white
    line through it. Ball and it's size is displayed by black lines.
 */
void mark_object(image greyimg, int x_middle, int y_middle, int object_size);

/** Search for ball.
    Search for reagions in rows, who's mean colour value fits the
    colour of the ball, return coordinates of its middle.
 */
int find_ball(int *x, int *y, int *size);

/** Search for goal.
    Search for reagions in rows, who's mean colour value fits the
    colour of the goal, return coordinates of its middle.
 */
int find_goal(int *x, int *y, int *size);

/** Get ball coordinates.
    Get position of ball on field as found out in image processing
    routines and orientation of ball towards goal.
*/
void get_ball_coord(PositionType *ball);

/** Get ball colour.
    Get current values for ball colour.
*/
int get_ball_col();

/** Get goal colour.
    Get current values for goal colour.
*/
int get_goal_col(int *blue_goal);

/** Change RBG to HSV -- use hue only. */
int RGBtoHue(BYTE r, BYTE g, BYTE b);


/*@}*/
