//## begin module%1.4%.codegen_version preserve=yes
//   Read the documentation to learn more about C++ code generator

//   versioning.

//## end module%1.4%.codegen_version



//## begin module%3D86D35E02D0.cm preserve=no

//	  %X% %Q% %Z% %W%

//## end module%3D86D35E02D0.cm



//## begin module%3D86D35E02D0.cp preserve=no

//## end module%3D86D35E02D0.cp


//## Module: Broadcaster%3D86D35E02D0; Pseudo Package specification

//## Source file: C:\Program Files\Rational\Rose\C++\source\Broadcaster.h

#ifndef Broadcaster_h

#define Broadcaster_h 1


//## begin module%3D86D35E02D0.additionalIncludes preserve=no

//## end module%3D86D35E02D0.additionalIncludes



//## begin module%3D86D35E02D0.includes preserve=yes

//## end module%3D86D35E02D0.includes



// Timer

#include "Timer.h"

// Radio

#include "Radio.h"

// Drive

#include "Drive.h"

// Thread

#include "Thread.h"

//## begin module%3D86D35E02D0.additionalDeclarations preserve=yes

//## end module%3D86D35E02D0.additionalDeclarations



//## begin Broadcaster%3D86D35E02D0.preface preserve=yes
//## end Broadcaster%3D86D35E02D0.preface


//## Class: Broadcaster%3D86D35E02D0
//	/**
//	This class implements the broadcasting abilities of the
//	robot. It is only needed when using communication by
//	broadcasting. The broadcasting algorithm makes sure that
//	a cluster point is determined and communicated to all
//	robots in the vicinity. It also makes sure that the
//	cluster point position is retained should the
//	broadcasting robot fail. See the system model for
//	details.
//	A new cluster point is set by resetting the robot
//	position. (0,0) is always used as cluster point position
//	as it is easier to push cubes to that position. Thus if
//	a new cluster point is chosen the current robot position
//	is adapted.
//	@author Jia L. Du
//	 */
//## Category: <Top Level>
//## Persistence: Transient
//## Cardinality/Multiplicity: n



class Broadcaster : public Thread  //## Inherits: <unnamed>%3D86D5A2019A
{
  //## begin Broadcaster%3D86D35E02D0.initialDeclarations preserve=yes
  //## end Broadcaster%3D86D35E02D0.initialDeclarations

  public:
    //## Constructors (specified)
      //## Operation: Broadcaster%3D9EBF96038E
      //	/**
      //	Constructor for Broadcaster. The parameters are passed
      //	to the Thread constructor
      //	@param name pointer to thread name
      //	@param stackSize size of thread stack
      //	@param priority thread priority (valid values are: MIN_
      //	PRI to MAX_PRI)
      //	@param id a unique thread id
      //	 */
      Broadcaster (char* name, int stackSize, int priority, int id);

    //## Other Operations (specified)
      //## Operation: setClusterPoint%3D9EC2090118
      //	/**
      //	Used to tell the broadcaster to set the robot's cluster
      //	point to the passed position. This is only done if
      //	Broadcaster::getHaveClusterPoint() returns false, i.e.
      //	if no cluster point was chosen yet. Otherwise the
      //	broadcaster ignores this command and decides himself
      //	which cluster point to use
      //	@param x x position of the new cluster point
      //	@param y y position of the new cluster point
      //	@return true if new cluster point accepted and set
      //	*/
      bool setClusterPoint (double x, double y);

      //## Operation: getHaveClusterPoint%3D9D3F8C038E
      //	/**
      //	@return true if the robot does already have a cluster
      //	point
      //	 */
      bool getHaveClusterPoint ();

    // Additional Public Declarations
      //## begin Broadcaster%3D86D35E02D0.public preserve=yes
      //## end Broadcaster%3D86D35E02D0.public

  protected:



    // Additional Protected Declarations
      //## begin Broadcaster%3D86D35E02D0.protected preserve=yes
      //## end Broadcaster%3D86D35E02D0.protected

  private:

    //## Other Operations (specified)
      //## Operation: broadcast%3D996A2E021C
      //	/**
      //	The robot broadcasts its current cluster point to all
      //	robots in the vicinity until it fails or realizes that a
      //	robot with a higher priority is broadcasting as well
      //	@see senderIsMe
      //	*/
      void broadcast ();

      //## Operation: processNextMessage%3D996A410032
      //	/**
      //	Processes one message in the message buffer. If there
      //	are no messages in the buffer it returns immediately.
      //	See system model for an explanation how these messages
      //	are used to spread the cluster point and to determine a
      //	broadcaster
      //	*/
      void processNextMessage ();

      //## Operation: mySenderInactive%3D9BEAA20258
      //	/**
      //	Checks if the robot from who I got my current cluster
      //	point and for who I have to continue broadcasting has
      //	failed
      //	@return true if that robot has failed
      //	 */
      bool mySenderInactive ();

    // Additional Private Declarations
      //## begin Broadcaster%3D86D35E02D0.private preserve=yes
      //## end Broadcaster%3D86D35E02D0.private

  private: //## implementation
    // Data Members for Class Attributes

      //## Attribute: haveClusterPoint%3D99692501A4
      //	/**
      //	Stores if the robot does already have a cluster point
      //	*/
      //## begin Broadcaster::haveClusterPoint%3D99692501A4.attr preserve=no  private: bool {U} false
      bool haveClusterPoint;
      //## end Broadcaster::haveClusterPoint%3D99692501A4.attr

      //## Attribute: senderIsMe%3D9969300384
      //	/**
      //	A flag that indicates if this robots should broadcast
      //	its cluster point
      //	*/

      //## begin Broadcaster::senderIsMe%3D9969300384.attr preserve=no  private: bool {U} false

      bool senderIsMe;

      //## end Broadcaster::senderIsMe%3D9969300384.attr



      //## Attribute: clusterPointDicoveryTime%3D996A5E006E

      //	/**

      //	Stores the time when the current cluster point was

      //	discovered (in hundreth seconds)

      //	 */

      //## begin Broadcaster::clusterPointDicoveryTime%3D996A5E006E.attr preserve=no  private: int {U} 0

      int clusterPointDicoveryTime;

      //## end Broadcaster::clusterPointDicoveryTime%3D996A5E006E.attr


      //## Attribute: myID%3D996A6B01C2

      //	/**

      //	Stores own robot ID for communication

      //	 */

      //## begin Broadcaster::myID%3D996A6B01C2.attr preserve=no  private: int {U} -1

      int myID;

      //## end Broadcaster::myID%3D996A6B01C2.attr



      //## Attribute: mySendersID%3D9BEAC8030C

      //	/**

      //	Stores the ID of the robot from who I got my current

      //	cluster point and for who I have to continue

      //	broadcasting if he fails

      //	 */

      //## begin Broadcaster::mySendersID%3D9BEAC8030C.attr preserve=no  private: int {U} -1

      int mySendersID;

      //## end Broadcaster::mySendersID%3D9BEAC8030C.attr



    // Data Members for Associations



      //## Association: <unnamed>%3D86D5E901E0

      //## Role: Broadcaster::<timer>%3D86D5EA01D6

      //	/**

      //	The Broadcaster has a Timer to determine cluster point

      //	ages

      //	*/

      //## begin Broadcaster::<timer>%3D86D5EA01D6.role preserve=no  public: Timer { -> RHN}

      Timer timer;

      //## end Broadcaster::<timer>%3D86D5EA01D6.role



      //## Association: <unnamed>%3D882DE7005A

      //## Role: Broadcaster::<radio>%3D882DE7035C

      //	/**

      //	The Broadcaster uses the Radio to communicate

      //	*/

      //## begin Broadcaster::<radio>%3D882DE7035C.role preserve=no  public: Radio { -> RHN}

      Radio *radio;

      //## end Broadcaster::<radio>%3D882DE7035C.role



      //## Association: <unnamed>%3D9AC9C303C0

      //## Role: Broadcaster::<drive>%3D9AC9CB010E

      //	/**

      //	The Broadcaster needs the Drive to set the cluster point

      //	*/

      //## begin Broadcaster::<drive>%3D9AC9CB010E.role preserve=no  public: Drive { -> RHN}

      Drive *drive;

      //## end Broadcaster::<drive>%3D9AC9CB010E.role



    // Additional Implementation Declarations

      //## begin Broadcaster%3D86D35E02D0.implementation preserve=yes

      //## end Broadcaster%3D86D35E02D0.implementation



};



//## begin Broadcaster%3D86D35E02D0.postscript preserve=yes

//## end Broadcaster%3D86D35E02D0.postscript



// Class Broadcaster 



//## begin module%3D86D35E02D0.epilog preserve=yes

//## end module%3D86D35E02D0.epilog





#endif

