//## begin module%1.4%.codegen_version preserve=yes
//   Read the documentation to learn more about C++ code generator
//   versioning.
//## end module%1.4%.codegen_version

//## begin module%3D86D3DF0244.cm preserve=no
//	  %X% %Q% %Z% %W%
//## end module%3D86D3DF0244.cm

//## begin module%3D86D3DF0244.cp preserve=no
//## end module%3D86D3DF0244.cp

//## Module: Thread%3D86D3DF0244; Pseudo Package specification
//## Source file: C:\Program Files\Rational\Rose\C++\source\Thread.h

#ifndef Thread_h
#define Thread_h 1

//## begin module%3D86D3DF0244.additionalIncludes preserve=no
//## end module%3D86D3DF0244.additionalIncludes

//## begin module%3D86D3DF0244.includes preserve=yes
#include "eyebot.h"
//## end module%3D86D3DF0244.includes

//## begin module%3D86D3DF0244.additionalDeclarations preserve=yes
//## end module%3D86D3DF0244.additionalDeclarations


//## begin Thread%3D86D3DF0244.preface preserve=yes
//## end Thread%3D86D3DF0244.preface

//## Class: Thread%3D86D3DF0244
//	/**
//	Base class from which all multithreaded classes are
//	derived. The derived classes inherit a set of methods
//	that can be used to control the thread. Once the thread
//	is spawned and made ready the run method is scheduled
//	for execution. The run method is declared as virtual and
//	has to be overwritten by the inheritor.
//	@author Jia L. Du
//	 */
//## Category: <Top Level>
//## Persistence: Transient
//## Cardinality/Multiplicity: n



class Thread
{
  //## begin Thread%3D86D3DF0244.initialDeclarations preserve=yes
  //## end Thread%3D86D3DF0244.initialDeclarations

  public:
    //## Constructors (specified)
      //## Operation: Thread%3D99171A00F0
      //	/**
      //	Constructor for Thread
      //	@param name pointer to thread name
      //	@param stackSize size of thread stack
      //	@param priority thread priority (valid values are: MIN_
      //	PRI to MAX_PRI)
      //	@param id a unique thread id
      //	 */
      Thread (char* name, int stackSize, int priority, int id);

    //## Destructor (generated)
//???      ~Thread();


    //## Other Operations (specified)
      //## Operation: spawn%3D9021FB00DC
      //	/**
      //	The thread is initialized and inserted in scheduler queue
      //	but not set to READY yet
      //	@return true if spawn was successful
      //	@see Thread::ready()
      //	 */
      bool spawn ();

      //## Operation: ready%3D9021F30104
      //	/**
      //	Sets the status of the thread to READY, i.e. it is
      //	scheduled for execution
      //	 */
      void ready ();

      //## Operation: suspend%3D90220202E4
      //	/**
      //	The status of the thread is set to SUSPENDED. It will
      //	not be scheduled for execution anymore until it is set to
      //	READY again
      //	@see Thread::ready()
      //	 */
      void suspend ();

      //## Operation: kill%3D9021F7024E
      //	/**
      //	The thread is removed and cannot be used anymore
      //	 */
      void kill ();

    // Additional Public Declarations
      //## begin Thread%3D86D3DF0244.public preserve=yes
      //## end Thread%3D86D3DF0244.public

  protected:

    //## Other Operations (specified)
      //## Operation: reschedule%3D902212000A
      //	/**
      //	Tells the scheduler to choose another thread for
      //	execution
      //	 */
      void reschedule ();

      //## Operation: sleep%3D9022160352
      //	/**
      //	Let the thread sleep for at least n hundreth seconds
      //	@param hundrethSeconds
      //	 */
      void sleep (int hundrethSeconds);

      //## Operation: run%3D99136F000A
      //	/**
      //	The method is overwritten by
      //	the inheritor. When the thread starts
      //	the code in this run method is executed
      //	 */
      static void run ();

      //## Attribute: threadControlBlock%3D941D7B0258
      //	/**
      //	Thread control blocks are used by the RoBIOS library to
      //	manage threads. This Thread class handles the thread
      //	control block internally thus hiding complexity from the
      //	user
      //	 */
      //## begin Thread::threadControlBlock%3D941D7B0258.attr preserve=no  protected: tcb* {U}
      tcb* threadControlBlock;
      //## end Thread::threadControlBlock%3D941D7B0258.attr

    // Additional Protected Declarations
      //## begin Thread%3D86D3DF0244.protected preserve=yes
			char* name;
			int stackSize;
			int priority;
			int id;
      //## end Thread%3D86D3DF0244.protected

  private:
    // Additional Private Declarations
      //## begin Thread%3D86D3DF0244.private preserve=yes
      //## end Thread%3D86D3DF0244.private

  private: //## implementation
    // Data Members for Class Attributes


    // Additional Implementation Declarations
      //## begin Thread%3D86D3DF0244.implementation preserve=yes
      //## end Thread%3D86D3DF0244.implementation

};

//## begin Thread%3D86D3DF0244.postscript preserve=yes
//## end Thread%3D86D3DF0244.postscript

// Class Thread

//## begin module%3D86D3DF0244.epilog preserve=yes
//## end module%3D86D3DF0244.epilog


#endif
