/// @file base.cc
/// @author Joshua Petitt <petitj01@tartarus.uwa.edu.au>
/// @author Stefan Schmitt <sschmitt@ee.uwa.edu.au>
/// @version 1.0
/// @date 2003-06
/// 
/// Implements base.hh.

#include "base.hh"

namespace EyeMind {

unsigned Tagged::ticket = 0;


Tagged::Tagged()
{
	tag = ++ticket;
}


bool Tagged::operator==(const Tagged& n)
{
	return (tag == n.tag);
}



void Updatable::Timebase(float t)
{
	OSPanicIf(timebase != 0, "Timebase already set");
	timebase = ((int)(100*t))/100.0;
}



Port::Port() : Updatable()
{
	active=true;
}


}; // namespace EyeMind

