/// @file constants.hh
/// @author Joshua Petitt <petitj01@tartarus.uwa.edu.au>
/// @author Stefan Schmitt <sschmitt@ee.uwa.edu.au>
/// @version 1.0
/// @date 2003-07
///
/// Common constants and small macros.
/// 

#ifndef CONSTANTS_HH
#define CONSTANTS_HH

#include <cstddef>


namespace EyeMind {

/// @name Wrappers for debug functions.
//@{
#ifdef DEBUG

#ifdef EYEBOT
#include "librobi/c-protos.h"
#include "librobi/c-stubs.h"

/// Print \b x on LCD (#ifdef DEBUG).
#define DEBUG_PRINT(x) LCDPrintf((x));

/// Printf \b x,y on LCD (#ifdef DEBUG).
#define DEBUG_PRINTF(x,y) LCDPrintf(x,y);

/// Wait for x/100 sec (#ifdef DEBUG).
#define DEBUG_WAIT(x) OSWait((x));

/// Beep (#ifdef DEBUG).
#define DEBUG_BEEP AUBeep();

/// Clear the screen
#define DEBUG_LCDCLEAR LCDClear();

#endif //EYEBOT

#else
#define DEBUG_PRINT(x)
#define DEBUG_PRINTF(x,y)
#define DEBUG_WAIT(x)
#define DEBUG_BEEP
#endif
//@}

/// @name Return values for non-boolean functions.
/// These should be uses for functions that do not imply a boolean \c return
/// value, but where error-checking is convenient. Return values greater than
/// 0 can be used as information-containing integer values, e.g. for handles.
/// 
//@{
const int OK=0;
const int NOK=-1;
//@}


}; // namespace EyeMind

#endif //CONSTANTS_HH
