/// @file factory.cc
/// @author Stefan Schmitt <sschmitt@ee.uwa.edu.au>
/// @version 1.0
/// @date 2003-07
/// 
/// Implements factory.hh.

#include "base/factory.hh"

namespace EyeMind {

// Explicit instantiation.
template LinkedList<Updatable>;



bool Updater::Update()
{
	Updatable* u = instances.Begin();
	while (u) {
		u->Update();
		u = ++instances;
	};

	return true;
}


void Updater::Register(Updatable& u)
{
	instances + u;
}


void Updater::Unregister(Updatable& u)
{
	instances - u;
}


}; // namespace EyeMind

