/// @file constant_behaviors.cc
/// Implements constant_behaviors.hh


#include "constant_behaviors.hh"

namespace EyeMind{

ConstantInteger::ConstantInteger()
{
	i=0;
}

ConstantInteger::ConstantInteger(int v)
{
	i=v;
}

int ConstantInteger::Execute()
{
	return EXCITE_IDLE;
}


ConstantInteger& operator<<(IntLink& l, ConstantInteger& i)
{
	SignalLinkInputToBehavior(l,i);
	return i;
}


IntLink& operator>>(ConstantInteger& n, IntLink& o)
{
	BehaviorOutputToSignalLink(n,o);
	return o;
}


}; // namespace EyeMind

