/// @file constant_behaviors.hh
///
/// Declare behaviors which put out constant values



#ifndef CONSTANT_BEHAVIORS_HH
#define CONSTANT_BEHAVIORS_HH

#include "behavior/stdc_linktypes.hh"

namespace EyeMind{


class ConstantInteger : public Behavior
{
private:
	int i;

protected:
	int Execute();

public:
	ConstantInteger();
	ConstantInteger(int);
};

ConstantInteger& operator<<(IntLink& l, ConstantInteger& i);
IntLink& operator>>(ConstantInteger& n, IntLink& o);


}; //namespace EyeMind

#endif //CONSTANT_BEHAVIORS_HH
