///@file pc_behaviors.cpp
///
/// Implements pc_behaviors.hh


#ifdef WIN32
#include "pc_behaviors.hh"

/**
 * KeyboardFeel Behavior.
 */
KeyboardFeel::KeyboardFeel() : keyboard(Keyboard::I())
{
}


int KeyboardFeel::Execute()
{
	return keyboard.Update();
}
  

void KeyboardFeel::Feed(SignalLink &l)
{
	if (!l.Generic())
		reinterpret_cast<CharLink&>(l).Char(keyboard.C());

	Behavior::Feed(l);
}


CharLink& operator>>(KeyboardFeel& n, CharLink& o)
{
	BehaviorOutputToSignalLink(n,o);
	return o;
}



/**
 * TerminalShow Behavior
 */
TerminalShow::TerminalShow() : terminal(Terminal::I())
{
}


int TerminalShow::Execute()
{
	StringLink *l = reinterpret_cast<StringLink*>(FindMaxNonGenericInputSignal());
	terminal.Str(l->String());
	terminal.Update();
	return 1;
}


TerminalShow& operator>>(StringLink& l, TerminalShow& o)
{
	SignalLinkOutputToBehavior(l,o);
	return o;
}

#endif //WIN32
