/**@file string_behaviors.hh
 *
 * Defines various behaviors that are useful for string manipulation
 *
 */


#ifndef STRING_BEHAVIORS_HH
#define STRING_BEHAVIORS_HH

#include "behavior/behavior.hh"
#include "behavior/stdc_linktypes.hh"
#include "behavior/stdcc_linktypes.hh"
#include <string>

using namespace std;

namespace EyeMind{

/// BufferString Behavior
/// @arg CharLink
/// @arg StringLink
class BufferString : public Behavior
{
private:
	string in_s;
	string out_s;

protected:
	int Execute();
	void Feed(SignalLink &l);

public:
	BufferString();
};

/// BufferString connection functions
BufferString& operator>>(CharLink& l, BufferString& o);
StringLink& operator>>(BufferString& n, StringLink& o);


/// BufferSentence Behavior
/// @arg StringLink
/// @arg StringLink
class BufferSentence : public Behavior
{
private:
	string in_s;
	string out_s;

protected:
	int Execute();
	void Feed(SignalLink &l);

public:
	BufferSentence();
};

// BufferSentence connection functions
BufferSentence& operator>>(StringLink& l, BufferSentence& o);
StringLink& operator>>(BufferSentence& n, StringLink& o);

}; // namespace EyeMind

#endif //STRING_BEHAVIORS_HH

