/// @file random.hh
/// @author Stefan Schmitt <sschmitt@ee.uwa.edu.au>
/// @version 1.0
/// @date 2003-06
/// @bug Implemented in header file.
/// 
/// Implements a wrapper class for rand() and some convenient helper
/// functions.

#ifndef RANDOM_HH
#define RANDOM_HH

#include "base/templates.hh"
#include "base/nodetypes.hh"
#include <cstdlib>

namespace EyeMind {

/// Random number generator; Singleton.
class Random : public Updatable
{
private:
	///Default constructor; initializes generator.
	Random() : Updatable(){ Seed(OSGetCount()); }

	NO_COPYING(Random);

public:
	SINGLETON(Random);

	/// Returns a random positive float <=max.
	float Float(float max);

	/// Returns a random float with abs()<=max.
	float FloatPM(float max);

	/// Returns randomly -1 or 1.
	int Sign();

	/// Seed the pseudo-random generator.
	void Seed(unsigned s){ srand(s); } 
};

inline float Random::Float(float max)
{
	return (max * rand() / (RAND_MAX + 1.0));
};


inline float Random::FloatPM(float max)
{
	return ((float) Sign() * Float(max));
};

inline int Random::Sign()
{
	int temp_rand;

	temp_rand = rand() & 1;
	if (temp_rand == 0)
		return 1;
	else
		return -1;
};


}; // namespace EyeMind

#endif // RANDOM_HH
