/// @file winmind_kernel.cc
/// @author Joshua Petitt
/// @date 2003
///
/// Implements winmind_kernel.hh


#ifdef WIN32
#include "winmind_kernel.hh"

#include <process.h>
#include <stdio.h>
#include <assert.h>

unsigned long master_p;
unsigned long act_p;
unsigned long think_p;


/* Acting thread */
void Act(void *pParams)
{
	while(1)
	{
		if(myId.Active())
		{
			myId.ExciteBehaviors();
		}
	}

	myId.Active(false);
	
	_endthread();
}


/* Thinking thread */
void Think(void *pParams)
{
	while(1)
	{
		if(myEgo.Active())
		{
			myEgo.Think();
		}
	}

	myEgo.Active(false);

	_endthread();
}


/* Main program */
int main(int argc, char *argv[])
{
	/* Make sure objects have been instantiated */
	assert(&myId);
	assert(&myEgo);
	assert(&mySuperEgo);

	
	/* Ready objects */
	myId.Ready();
	myEgo.Ready();
	mySuperEgo.Ready();
    

	/* Initialize threads */
	printf("\nstarting mind\n");
	printf("Id ");
	act_p = _beginthread(Act,0,NULL);	
	printf("ok\n");

	printf("Ego ");
	think_p = _beginthread(Think,0,NULL);
	printf("ok\n");

 
	printf("\npress Ctrl+c to exit\n");
	/* Wait for threads to process */
	while(myId.Active())
	{
	}	

	printf("Done\n");

	return 0;
}

#endif //WIN32


