/// @file memorymap.hh
/// @author Joshua Petitt <petitj01@mech.uwa.edu.au>
/// @bug This unfortunately is completely unimplemented.
/// 
/// Declares a "memory-map" which is used to map the current state
/// of the agent (i.e. robot) to a desired state.

#ifndef MEMORY_MAP_HH
#define MEMORY_MAP_HH

#include "state/state.hh"

namespace EyeMind {

/// Abstrace base class; declares an interface for any decision making 
/// memory (i.e. long-term).  The memory map should map a set of current
/// behavior states to a set of states for the Ego to process.

class MemoryMap
{
public:
	MemoryMap(){}
	virtual ~MemoryMap(){}

	virtual int Create() = 0;
	virtual int Load() = 0;
	virtual int Save() = 0;
};


class State;


/// Maps the current state of the robot to a desired state.

class StateMemoryMap : public MemoryMap
{
private:

public:
	StateMemoryMap(){}
	~StateMemoryMap(){}

	// Mapping function
	virtual State* Map(States* states)
	{
		if (states == NULL)
			return NULL;

		// Do something here
		return NULL;
	}

	// Virtual functions definitions
	virtual int Create()
	{
		// Allocate any data here
		return 0;
	}

	virtual int Load()
	{
		return 0;
	}

	virtual int Save()
	{
		return 0;
	}
};


}; // namespace EyeMind

#endif // MEMORY_MAP_HH
