/// @file wrappers.cc

#include "mind/wrappers.hh"

namespace EyeMind {

Updatable* UpdatableFunctionWrapper::instances[MAX_IRQ] = {NULL};
unsigned UpdatableFunctionWrapper::count = 0;

void (*UpdatableFunctionWrapper::For(Updatable& u))()
{
	// No checking for MAX_IRQ here, this has to be done at higher levels.
	instances[count] = &u;
	++count;

	switch (count) {
	case 1: return Function0;
	case 2: return Function1;
	case 3: return Function2;
	case 4: return Function3;
	case 5: return Function4;
	case 6: return Function5;
	case 7: return Function6;
	case 8: return Function7;
	case 9: return Function8;
	case 10: return Function9;
	case 11: return Function10;
	case 12: return Function11;
	case 13: return Function12;
	case 14: return Function13;
	case 15: return Function14;
	case 16: return Function15;
	};
	
	// echo "cast NULL into pointer to function returning void;"|cundecl
	return (void (*)())NULL;
};


Behavior* BehaviorFunctionWrapper::instances[MAX_IRQ] = {NULL};
unsigned BehaviorFunctionWrapper::count = 0;

void (*BehaviorFunctionWrapper::For(Behavior& b))()
{
	// No checking for MAX_IRQ here, this has to be done at higher levels.
	instances[count] = &b;
	++count;

	switch (count) {
	case 1: return Function0;
	case 2: return Function1;
	case 3: return Function2;
	case 4: return Function3;
	case 5: return Function4;
	case 6: return Function5;
	case 7: return Function6;
	case 8: return Function7;
	case 9: return Function8;
	case 10: return Function9;
	case 11: return Function10;
	case 12: return Function11;
	case 13: return Function12;
	case 14: return Function13;
	case 15: return Function14;
	case 16: return Function15;
	};
	
	// echo "cast NULL into pointer to function returning void;"|cundecl
	return (void (*)())NULL;
};


}; // namespace EyeMind

