/**@file dictionary.cc
 *
 * Implements dictionary.hh
 *
 */

#include "dictionary.hh"

#ifdef WIN32
#include <fstream>
#include <iostream>
using namespace std;
#endif

#ifdef EYEBOT
#include "eyebot_behavior_types.h"
#include "eyebot_behavior_sem.h"

// Explicit instantiation
template Array<dictionary_entry_t, DICTIONARY_SIZE>;
template Array<Index::entry_t,INDEX_SIZE>;
#endif


#if 0
#ifdef WIN32
Dictionary::Dictionary()
{
}


int Dictionary::Find(const char* name)
{
	map<string, int>::iterator = entries.find(s);

	if(i!=entries.end())
		return (*i).second;
	else
		return -1;
}


// Load the dictionary from a file
bool Dictionary::Load(const char* filename)
{
	fstream fs;
	size_t lnum, pos;
	string line, name, value;
	char c;
	int num;

	fs.open(filename,ios::in);

	lnum = 0;
	while(fs.good())
	{
		getline(fs,line);

		if(fs.good())
		{
			++lnum;

			c = *line.begin();

			// check for comment
			if(c!='#')
			{
				pos = line.find_first_of(" ");
				if(pos!=line.npos)
				{
					name = line.substr(0,pos);
					value = line.substr(pos+1);

					num = atoi(value.c_str());

					entries[name] = num;

					cout << name << " " << num << endl;
				}
			}
		}
	}

	fs.close();

	return true;
}
#endif
#endif

#ifdef EYEBOT
Dictionary::Dictionary()
{
	for(int i=0;i<DICTIONARY_SIZE;i++)
	{
		catalog.Append(data[i]);
	}
	catalog.Begin(); // set iterator to beginning

	Dictionary::Load();
}

void Dictionary::Add(const char* name, int value)
{
	dictionary_entry_t *e = ++catalog;
	if(e!=NULL)
	{
		strcpy(e->ref,name);
		e->val = value;
	}
}

int Dictionary::Find(const char* name)
{
	dictionary_entry_t *e;
	for(unsigned i=0;i<catalog.Size();i++)
	{
		e = catalog[i];
		if(e!=NULL)
		{
			if(!strcmp(name,e->ref))
				return e->val;
		}
	}
	return -1;
}

const char* Dictionary::Get(int val)
{
	dictionary_entry_t *e;
	for(unsigned i=0;i<catalog.Size();i++)
	{
		e=catalog[i];
		if(e!=NULL && val==e->val)
			return e->ref;
	}
	return NULL;
}


// Load the dictionary from HDT
bool Dictionary::Load()
{
	dictionary_entry_t entry;
	dictionary_t *dt = (dictionary_t*) HDTFindEntry(DICTIONARY,0);
	OSPanicIf(dt==NULL,"\nCannot find\ndictionary data\n");

	DEBUG_PRINT("Dictionary\n---------------\n");
	for(int i=0;i<dt->length;i++)
	{
		entry = dt->data[i];
		Add(entry.ref,entry.val);
		DEBUG_PRINTF("%s ",entry.ref);
		DEBUG_PRINTF("%d\n",entry.val);
	}
	DEBUG_PRINT("---------------\n");

	return true;
}


Index::Index()
{
	for(int i=0;i<INDEX_SIZE;i++)
	{
		catalog.Append(data[i]);
	}
	catalog.Begin();
}

void Index::Add(int reference, int value)
{
	entry_t *e = ++catalog;
	if(e!=NULL)
	{
		e->ref=reference;
		e->val=value;
	}
}

int Index::Find(int reference)
{
	entry_t *e;
	for(unsigned i=0;i<catalog.Size();i++)
	{
		e = catalog[i];
		if(e!=NULL)
		{
			if(e->ref==reference)
				return e->val;
		}
	}
	return -1;
}

// Load the Index from HDT
bool Index::Load()
{
	index_entry_t entry;
	index_t *dt = (index_t*) HDTFindEntry(INDEX,0);
	OSPanicIf(dt==NULL,"\nCannot find\nindex data\n");

	DEBUG_PRINT("Index\n---------------\n");
	for(int i=0;i<dt->length;i++)
	{
		entry = dt->data[i];
		Add(entry.ref,entry.val);
		DEBUG_PRINTF("%d ",catalog.Pos());
		DEBUG_PRINTF("%d ",catalog[catalog.Pos()]->ref);
		DEBUG_PRINTF("%d\n",catalog[catalog.Pos()]->val);
	}
	DEBUG_PRINT("---------------\n");

	return true;
}

#endif

