/**@file pcmind.hh
 * Implentation of the mind for a Windows PC
 */

#ifdef WIN32

#ifndef PCMIND_HH
#define PCMIND_HH


#include "mind/mind.hh"
#include "behavior/pc_behaviors.hh"
#include "behavior/string_behaviors.hh"
#include "behavior/stdc_linktypes.hh"
#include "behavior/stdcc_linktypes.hh"


class PCId : public Id
{
friend class PCEgo;

private:
	TerminalShow terminal;
	KeyboardFeel keyboard;
	BufferString wordbuffer;
	BufferSentence sentencebuffer;

	StringLink stringlink[2];
	CharLink charlink;

protected:

public:
	PCId()
	{
	}

	// Create behavior trees for socccer robots
	int Ready()
	{
		DEBUG_PRINT("\nReady Id\n");

		// INSERT CODE HERE

		/* Echo keyboard to the terminal */
		*this>>keyboard;
		keyboard >> charlink >> wordbuffer >> stringlink[0] >> sentencebuffer >> stringlink[1] >> terminal;
		


		DEBUG_PRINTF("%d root(s)\n",behaviors.Count());
		DEBUG_PRINTF("%d inputs(s)\n",inputs.Count());
		DEBUG_PRINTF("%d outputs(s)\n",outputs.Count());

		DEBUG_WAIT(100);

		/* Activate and return */
		Active(1);
		return 0;
	}
} myId;


/**
 * A Ego for soccer robots
 */
class PCEgo : public Ego
{
private:

public:
	PCEgo(){};
	virtual ~PCEgo(){};

	virtual int Ready()
	{
		DEBUG_PRINT("\nReady Ego\n");

		// Create truth "trees"


		/// Add "normal" states (i.e. always want to be true)
		//states + position;

		/// Add "task" states (i.e. list of states to accomplish a task)

		DEBUG_PRINTF("%d states(s)\n",states.Count());
		DEBUG_PRINTF("%d task(s)\n",task.Count());

		Active(true);
		return 1;
	}
} myEgo;


/**
 * A SuperEgo for soccer robots
 */
class PCSuperEgo : public SuperEgo
{
private:

public:
	PCSuperEgo()
	{
		//statemap.Create();
	}

	virtual ~PCSuperEgo()
	{
	}

	virtual int Ready()
	{
		DEBUG_PRINT("\nReady SuperEgo\n");

		return 1;
	}

} mySuperEgo;



#endif //PCMIND_HH
#endif //WIN32
