/// @file bad_examples.cc
/**
 * Implements speech_behaviors.h
 */

#include "behavior/speech_behaviors.hh"
#include "mind/mind.hh"

namespace Soccer03 {

#if 0


#if 0
Word Say(int w)
{
	Word word;

	switch(w)
	{
	case(W_HI):
		word.sound[0].tone = HIGH_TONE;
		word.sound[0].duration = SHORT_TONE;
		strcpy(word.letter,"hi");
		break;

	case(W_BYE):
		word.sound[0].tone = LOW_TONE;
		word.sound[0].duration = SHORT_TONE;
		strcpy(word.letter,"bye");
		break;

	case(W_OK):
		word.sound[0].tone = HIGH_TONE;
		word.sound[0].duration = LONG_TONE;
		word.sound[1].tone = LOW_TONE;
		word.sound[1].duration = SHORT_TONE;
		strcpy(word.letter,"ok");
		break;

	case(W_OUCH):
		word.sound[0].tone = HIGH_TONE;
		word.sound[0].duration = SHORT_TONE;
		word.sound[1].tone = MID_TONE;
		word.sound[1].duration = SHORT_TONE;
		word.sound[2].tone = LOW_TONE;
		word.sound[2].duration = SHORT_TONE;
		strcpy(word.letter,"ouch");
		break;

	case(W_HELP):
		word.sound[0].tone = HIGH_TONE;
		word.sound[0].duration = LONG_TONE;
		word.sound[1].tone = LOW_TONE;
		word.sound[1].duration = SHORT_TONE;
		word.sound[2].tone = HIGH_TONE;
		word.sound[2].duration = LONG_TONE;
		strcpy(word.letter,"help");
		break;

	case(W_GOOD):
		word.sound[0][0] = LOW_TONE;
		word.sound[0][1] = SHORT_TONE;
		word.sound[1][0] = MID_TONE;
		word.sound[1][1] = SHORT_TONE;
		word.sound[2][0] = HIGH_TONE;
		word.sound[2][1] = SHORT_TONE;
		strcpy(word.letter,"good");
		break;

	case(W_GO):
		word.sound[0][0] = LOW_TONE;
		word.sound[0][1] = SHORT_TONE;
		word.sound[1][0] = MID_TONE;
		word.sound[1][1] = SHORT_TONE;
		word.sound[2][0] = HIGH_TONE;
		word.sound[2][1] = SHORT_TONE;
		strcpy(word.letter,"go");
		break;

	case(W_STOP):
		word.sound[0][0] = LOW_TONE;
		word.sound[0][1] = SHORT_TONE;
		word.sound[1][0] = MID_TONE;
		word.sound[1][1] = SHORT_TONE;
		word.sound[2][0] = HIGH_TONE;
		word.sound[2][1] = SHORT_TONE;
		strcpy(word.letter,"stop");
		break;

    default:
		break;
    }

  return word;
}

#endif

#endif


int SpeakRadio::Execute()
{
	CharArrayLink* l = reinterpret_cast<CharArrayLink*>
		(FindMaxNonGenericInputSignal());

	if(l==NULL) return 0;

	//DEBUG_PRINTF("%s\n",l->CharArray());

	radio.Message(l->CharArray());
	radio.Update();

	return 0;
}

SpeakRadio& operator>>(CharArrayLink& l, SpeakRadio& o)
{
	SignalLinkOutputToBehavior(l,o);
	return o;
}

CharArrayLink& operator<<(SpeakRadio& n, CharArrayLink& i)
{
	BehaviorInputToSignalLink(n,i);
	return i;
}




/**
 * SayString Behavior
 */

SayString::SayString() : dictionary(*Mind::ActiveDictionary())
{
	memset(string,0,DEFAULT_SPOKEN_STRING_LENGTH);
}

SayString::~SayString()
{
	memset(string,0,DEFAULT_SPOKEN_STRING_LENGTH);
}

int SayString::Execute()
{
	IntLink *l = reinterpret_cast<IntLink*>(FindMaxNonGenericInputSignal());
	if(l==NULL) return 0;

	strcpy(string,dictionary.Get(l->Int()));

//	DEBUG_PRINTF("%s\n",string);
	return EXCITE_IDLE;
}

CharArrayLink& operator>>(SayString& n, CharArrayLink& l)
{
	BehaviorOutputToSignalLink(n,l);
	l.CharArray(n.string);
	return l;
}

SayString& operator<<(CharArrayLink& l, SayString& n)
{
	SignalLinkInputToBehavior(l,n);
	l.CharArray(n.string);
	return n;
}


SayString& operator>>(IntLink& l, SayString& o)
{
	SignalLinkOutputToBehavior(l,o);
	return o;
}


IntLink& operator<<(SayString& n, IntLink& i)
{
	BehaviorInputToSignalLink(n,i);
	return i;
}


/**
 * SayConstString Behavior
 */

SayConstString::SayConstString()
{
	memset(string,0,DEFAULT_SPOKEN_STRING_LENGTH);
}

SayConstString::SayConstString(const char* s)
{
	memset(string,0,DEFAULT_SPOKEN_STRING_LENGTH);
	strcpy(string,s);
}

SayConstString::~SayConstString()
{
	memset(string,0,DEFAULT_SPOKEN_STRING_LENGTH);
}

int SayConstString::Execute()
{
	return EXCITE_IDLE;
}

CharArrayLink& operator>>(SayConstString& n, CharArrayLink& l)
{
	BehaviorOutputToSignalLink(n,l);
	l.CharArray(n.string);
	return l;
}

SayConstString& operator<<(CharArrayLink& l, SayConstString& n)
{
	SignalLinkInputToBehavior(l,n);
	l.CharArray(n.string);
	return n;
}



/**
 * InterpretString Behavior
 */

//InterpretString::InterpretString() : dictionary(*Mind::ActiveDictionary())
InterpretString::InterpretString()
{
}

int InterpretString::Execute()
{
	CharArrayLink *l = reinterpret_cast<CharArrayLink*>(FindMaxNonGenericInputSignal());
	if(l==NULL) return 0;

//	DEBUG_PRINTF("C:%s\n",l->CharArray());
	index = dictionary.Find(l->CharArray());
//	DEBUG_PRINTF("DI:%d\n",index);

	if(index<0)
		return 0;
	else
		return 1;
}


void InterpretString::Feed(SignalLink &l)
{
	if ( !l.Generic() )
		reinterpret_cast<IntLink&>(l).Int(index);

	Behavior::Feed(l);
}


InterpretString& operator>>(CharArrayLink& l, InterpretString& o)
{
	SignalLinkOutputToBehavior(l,o);
	return o;
}


InterpretString& operator<<(IntLink& l, InterpretString& i)
{
	SignalLinkInputToBehavior(l,i);
	return i;
}


IntLink& operator>>(InterpretString& n, IntLink& o)
{
	BehaviorOutputToSignalLink(n,o);
	return o;
}


CharArrayLink& operator<<(InterpretString& n, CharArrayLink& i)
{
	BehaviorInputToSignalLink(n,i);
	return i;
}


/**
 * InterpretIRTV
 */

InterpretIRtv::InterpretIRtv()
{
#ifdef EYEBOT
	reference.Load();
#endif
}

int InterpretIRtv::Execute()
{
	IntLink *l = reinterpret_cast<IntLink*>(FindMaxNonGenericInputSignal());
	if(l==NULL) return 0;

	index = reference.Find(l->Int());

//	DEBUG_PRINTF("I:%d\n",index);

	if(index<0)
		return 0;
	else
		return 1;
}

void InterpretIRtv::Feed(SignalLink &l)
{
	if (!l.Generic())
		reinterpret_cast<IntLink&>(l).Int(index);

	Behavior::Feed(l);
}


InterpretIRtv& operator>>(IntLink& l, InterpretIRtv& o)
{
	SignalLinkOutputToBehavior(l,o);
	return o;
}


InterpretIRtv& operator<<(IntLink& l, InterpretIRtv& i)
{
	SignalLinkInputToBehavior(l,i);
	return i;
}


IntLink& operator>>(InterpretIRtv& n, IntLink& o)
{
	BehaviorOutputToSignalLink(n,o);
	return o;
}


IntLink& operator<<(InterpretIRtv& n, IntLink& i)
{
	BehaviorInputToSignalLink(n,i);
	return i;
}





}; // namespace Soccer03

