// Shows how to use Behaviors, SignalLinks and adapters
#include <stdio.h>
#include "behavior/example.hh"
#include "behavior/example-adapter.hh"
#include "behavior/control_behaviors.hh"

int main()
{
	PolarLink pl;
	CartesianLink cl;
	CartesianToPolar ctp;
	FloatPrinter fp;
	PolarToPhi ptf;

	//Behaviour to turn the head
	TurnHead turnHead;
	

	Cartesian c;
	c.x = 1;
	c.y = 1;

	cl.Coord(c);
	cl.Update();

	ctp << cl;  //is this equivilant to cl >> ctp ????
	ctp >> pl;
	//ctp >> ptf;  //should this be pl >> ptf ????
	//ptf >> fp;

	pl >> turnHead;

	ctp.Excite(1);
	pl.Update();


	pl.Update();
	ptf.Update();

	printf("%f %f\n", pl.Coord().r, pl.Coord().phi);

	fp.Excite(1);

	return 0;
}
