/**
 * Data for the Mind behaviors
 */

#ifndef EYEBOT_BEHAVIOR_DATA_H
#define EYEBOT_BEHAVIOR_DATA_H

#include "eyebot_behavior_types.h"

twowheeldrive_bt twowheeldrive_data = {
	0.022,   		// radius
	0.142			// width
};

findball_bt findball_data = {
	105,			// hue
	6,			// Threshold (distance from Hue)
	210,			// intensity low thresh   446
	630,			// intensity high thresh  718
	19,			// K parameter (for detecting grey) FAR AWAY
	540,			// K parameter (very close) [less sensitive to grey/white]
	4			// required number of matching pixels (1 to 5)
};

trackheading_bt attack_data = {
	10,			/* deadband (degrees) */
	1.05,			/* Gain (Kw) .85 */
	40,			/* dband_psd */
	1.0,			/* left bias */
	1.0,			/* right bias */
	2.0,			/* velocity (fast/striking) when centred and lined-up */
	0.4,			/* velocity (slow) when centring. */
	0.0,			/* velocity (slow_ when turning. */
	0.5,			/* w velocity (when centring). */
	45,			/* max turn rate (degrees) */
	0,			/* compass offset (set to 180 to point to own-goal) */
	0			/* internal offset */
};

trackheading_bt defend_data = {
	20,			/* deadband (degrees) */
	1.85,			/* Gain (Kw) .85 */
	60,			/* dband_psd */
	1.2,			/* left bias */
	1.0,			/* right bias */
	0.6,			/* velocity (fast/striking) when centred and lined-up */
	0.3,			/* velocity (slow) when centring. */
	0.0,			/* velocity (slow) when turning */
	0.4,			/* w velocity (when centring). */
	180,			/* max turn rate (degrees) */
	180,			/* compass offset (set to 180 to point to own-goal) */
	  0			/* internal offset */
};


trackheading_bt attackball_data = {
	20,			/* deadband (degrees) */
	3.0,			/* Gain (Kw) .85 */
	60,			/* dband_psd */
	1.0,			/* left bias */
	1.0,			/* right bias */
	0.8,			/* velocity (fast/striking) when centred and lined-up */
	0.3,			/* velocity (slow) when centring. */
	-0.1,			/* velocity (slow) when turning. */
	1.0,			/* w velocity (when centring). w_slow */
	60,			/* max turn rate (degrees) */
	0,			/* compass offset (set to 180 to point to own-goal) */
	2			/* internal offset */
};

vwdrive_bt vwdrive_data = {
	-30,			/* axle angular-velocity limit low */
	30,			/* axle angular-velocity limit high */
	/* PID control parameters with 1st order approximation */
	5.0,			/* Kp */
	0.07,			/* Reset time (KI??) */
	0.01			/* rate time  (KD??) */
};

motorcontrol_bt motorcontrol_data = {
	// detect motor is stalled:
	30,			/* time-units until stall is declared */
	0.005			/* angular velocity deadband */
};

turnhead_bt turnhead_data = {
	0.35,			/* Kp */
	0.05,			/* deadband */
	/* Ball close thesholds */
	9.0,			/* range close (less then) */
	25.0,			/* phi close ( between +/- degrees) */
	0			/* Grace period - time-ticks before we declare the ball 'not found' */
};

turncommand_bt turncommand_data = {
	0.02,			/* v/r gain. */
	2.2,			/* w/phi gain. */
	20,			/* phi deadband */
	0.12,			/* speed (close) */
	0.0,			/* w/phi gain (close) */
	3.0,			/* w/phi gain (close, out of phi deadband) */
	0.0,			/* Speed when turning (close, out of phi deadband) */
	14,			/* close threshold */
};

dcmotor_bt dcmotor_data = {
	540,			/* ticks per revolution */
	0.01			/* motor timebase (seconds) */
};

centre_bt centre_data = {
	40,			/* deadband (psd-units) */
	0.02,			/* gain */
	0.7,			/* left PSD bias */
	1.0,			/* right PSD bias
	40,			/* max rate of turn (degrees) */
	0.1,			/* velocity component when turning */
	0.8			/* velocity component when lined-up and trying to score */
};

avoid_bt avoid_data = {
	100,			/* distance to avoid (side) (PSD units) */
	100,			/* distance to avoid (front) */
	130,			/* distance to avoid (back) */
	0.8,			/* w_avoid_high */
	0.3,			/* w_avoid_low */
	0.2, 			/* v_avoid_high */
	0.1,			/* v_avoid_low */
	1			/* grace, time units to keep reversing */
};

stall_bt stall_data = {
	1.0,			/* stall gain */
	20			/* time units */
};

wander_bt wander_data = {
	0.1,			/* Forward wander velocity (cannot be zero) */
	1.1,			/* turning velocity 1.0 */
	8			/* period (time-units) eg turns for 10, forward for 10, turn for 10, ...
};

reacquire_bt reacquire_data = {
	15,			/* ticks until reacquire behavior exhausts */
	6,			/* start period */
	-0.15,			/* reacquire velocity (usually -ve so robot reverses) */
	-0.5			/* reacquire turn-rate. */
};

motion_bt stop_data    = {0.0, 0.0};
motion_bt kickoff_data = {0.8, 10.0};

dictionary_t dictionary_data = {
	2,			/* total number of words */
	{{"attack\0 ",0},
	 {"defend\0 ",1}}
};

index_t irtvindex_data = {
	3,		/* total number of commands */
	{
	 {0x6112,0},	/* play */
	 {0x606D,1},	/* stop */
	 {0x6166,2}	/* OK (kickoff), use for FORWARD */
/*	 {0x6166,0}	/* OK (kickoff), use for FULLBACK */
	}
};

player_t player_data = {
	PLAYER_FORWARD,
	20
};

#endif /*HDT_BEHAVIOR_DATA_H*/
