#include "serial_communications.h"

#include "librobi/librobi.h"
#include "librobi/protos.h"

#include "keys.h"
#include "lcd.h"
#include "cam.h"
#include "types.h" 
#include "kern.h"

#include <math.h>
#include <stdio.h>
#include <unistd.h>

/** Radio channel */
extern Channel radio_channel; 

/** Identification Variables */
char my_id, next_id;

/** Variable for PC feedback */
extern int mid_packet;

void main()
{
  int i;
  int key, speed; 
  bool master_station;
  char message1[] = {"First String"}, message2[] = {"SecStr"};
  char message[100];
  
  /** disable input/output buffer */
  setvbuf (stdout,NULL,_IONBF,0);       
  setvbuf (stdin,NULL,_IONBF,0);        

  /** clear display and set display mode */
  LCDClear();
  LCDMode(SCROLLING|NOCURSOR);

#if PC_SERIAL_CHECK
  mid_packet = 1;
#endif
  
  /* Initialise Communications Channel */
  RadioInit(2);
  next_id = radio_channel.next_address[0] - 48;
  LCDPrintf("My add = %c\n", radio_channel.my_address[0]);
  LCDPrintf("Next id = %c\n", next_id + 48);
  
  key = 0;
  LCDMenu("Str1","Str2","Rec","End");    
  while(key!=KEY4) {
    key = KEYGet();
    switch(key) {
    case KEY1: 
      if(RadioTx(next_id, message1, 13))
	LCDPrintf("%s\n", message1);
      else LCDPrintf("Queue Full");
      break;
    case KEY2:
      if(RadioTx(next_id, message2, 10))
	LCDPrintf("%s\n", message2);
      else LCDPrintf("Queue Full");
      break;
    case KEY3:
      i = 0;
      LCDClear();
      while (RadioRx(message)!=-1) {
	LCDPrintf("%d:%s.\n", i, message);
	i++;
      }
      LCDMenu("Str1","Str2","Rec","End");
      break;
    case KEY4:
      
      break;
    }
  }
  RadioRelease();
}



