/***********************************************************************/
/** @name image.h 
    @author Birgit Graf, UWA, 1998
*/
/***********************************************************************/

#define LEFT_EDGE_ZONE imagecolumns*0.5
#define RIGHT_EDGE_ZONE imagecolumns*0.5



/*@{*/

/**
   Update_Ball_Direction
   This function is used to update the ball's direction. Must be called after all attempts
   to locate ball.
*/
void Update_Ball_Direction(float New_X, float New_Y, int update_type);


/**
   Init camera.
 */
void InitCam();

/** Change camera parameters.
    Changes brightness, hue and saturation in case default values
    aren't good enough (e.g. different light conditions). Function as
    in RoBiOS-Setup, but without camera-initialisation, works only for
    colour-camera.
 */
void set_cam_parameters();

/** Change parameters.
    Changes thresholds which are used to select ball/goal coloured
    pixels from others and size of ball/goal.
 */
void set_img_parameters();
/** Set wall colour.
    Set wall colour to colour detected in middle of picture
    (mean value of 5x5 area around middle of picture).
 */
void set_wall_colour(colimage img);


/** Set Ball colour.
    Set ball colour to colour detected in middle of picture
    (mean value of 5x5 area around middle of picture).
 */
void set_ball_colour(colimage img);

/** Set Goal colour.
    Set goal colour to colour detected in middle of picture
    (mean value of 5x5 area around middle of picture).
 */
void set_goal_colour(colimage img);

/** Mark object.
    Convert colour picture into greyscale (for LCD output),
    mark goal position by drawing a vertical and horizontal white
    line through it. Ball and it's size is displayed by black lines.
 */
void mark_object(image greyimg, int x_middle, int y_middle, int object_size);

/** Search for ball.
    Search for reagions in rows, who's mean colour value fits the
    colour of the ball, return coordinates of its middle.
 */
int find_ball(int *x, int *y, int *size);

/** Search for goal.
    Search for reagions in rows, who's mean colour value fits the
    colour of the goal, return coordinates of its middle.
 */
int find_goal(int *x, int *y, int *size);

/** Check for ball.
    Analyse picture by calling find_object and checking camera
    position, set see_ball_flag and got_ball_flag respectively.
*/
void PPball_test();

/** Get ball coordinates.
    Get position of ball on field as found out in image processing
    routines and orientation of ball towards goal.
*/
void get_ball_coord(PositionType *ball);

/** Get ball colour.
    Get current values for ball colour.
*/
int get_ball_col();

/** Get goal colour.
    Get current values for goal colour.
*/
int get_goal_col(int *blue_goal);

/** Change RBG to HSV -- use hue only. */
int RGBtoHue(BYTE r, BYTE g, BYTE b);

/**  Converts just a row of the image to HSV */
void ConvertRowToHSV(BYTE *in, BYTE *out, int row);

/** Converts just a column of the image to HSV */
void ConvertColumnToHSV(BYTE *in, BYTE *out, int column);

/*Change RBG to HSV -- use intensity only.*/
int RGBtoSaturation(BYTE r, BYTE g, BYTE b);

/** Convert an rgb image to intensity in grayscale.*/
void HSVsaturation(BYTE *imageIn, BYTE *imageOut);


/**     Determines the next row to search. */
int NextRow(int *lastup, int *lastdown, int *lastdir);

/*@}*/
