/* ************************************************ */
/* This program uses fast switching of the LCD      */
/* to simulate gray scale display mode              */
/* Authors: Lecerlcq, Braunl, 2000                  */
/* ************************************************ */

#include <eyebot.h>

const int bwimagerows = 64;
const int bwimagecolumns = 128;

void make_parts(image gray_image, BYTE *bwimg1, BYTE *bwimg2, BYTE *bwimg3)
{
  int column,row,i;
  for (row=1; row<imagerows-1; row++) {
    for (column=1; column<imagecolumns-1; column+=8)
      {
	int bwimgpos = (row-1)*bwimagecolumns/8+(column-1)/8;
	BYTE value1 = 0, value2 = 0, value3 = 0;

	for (i=0; i<8; i++) {
	  int lum = (15 -gray_image[row][column+(7-i)]) >> 1; /* range 0..7 */

	  value1 |= ((lum&4)>>2) <<i;
	  value2 |= ((lum&2)>>1) <<i;
	  value3 |= ( lum&1)     <<i;
	}
	bwimg1[bwimgpos]=value1;
	bwimg2[bwimgpos]=value2;
	bwimg3[bwimgpos]=value3;
      }
  }
}

int main()
{
  int bwimagesize = (bwimagecolumns/8)*bwimagerows;
  image gray_image;
  BYTE bwimg1[bwimagesize];
  BYTE bwimg2[bwimagesize];
  BYTE bwimg3[bwimagesize];
  int  i;

  CAMInit(NORMAL);
  CAMMode(AUTOBRIGHTNESS);

  for (i=0; i<bwimagesize; i++) {
    bwimg1[i]=0x00;
    bwimg2[i]=0x00;
    bwimg3[i]=0x00;
  }

  LCDMenu(" ", " ", " ", "END");

  i = 0;
  while (KEY4 != KEYRead())
    {
      if (0 == (i++ % 10))
	{
	  CAMGetFrame(&gray_image);
	  make_parts(gray_image, bwimg1, bwimg2, bwimg3);
	}
      LCDPutImage(bwimg1);
      LCDPutImage(bwimg2);
      LCDPutImage(bwimg1);
      LCDPutImage(bwimg3);
      LCDPutImage(bwimg1);
      LCDPutImage(bwimg1);
      LCDPutImage(bwimg2);
  }
  return 0;
}

