/*
| ------------------------------------------
| Filename: commdemo.c
|
| Author:   Thomas Braunl, braunl@ee.ua.edu.au, June 1998
|
| Description: 
| serial I/O over wireless link or cable
| -----------------------------------------
*/

#include "eyebot.h"

char str1[] = "0123456789";
char str2[] = "HELLOhello";
char str3[] = "....................";
char *s;

int main (void)
{ char key, id, from, rev_char;
  int  num, last = 0;
  int key2_pressed=0;
  int i;
  
  LCDPrintf("Wireless\n");
  LCDMenu("Snd","Ser","","END");

  /* demo only: send 1->2, 2->1 */
  if (OSMachineID()==(unsigned char)1) id=(char)2; else id=(char)1;
  LCDPrintf("Sending from %d to %d\n", (int) OSMachineID(), (int) id);
  RADIOInit();
  
  do
  { switch(key=KEYRead())
  
    { case KEY1:
	if (last) s = str1; else s = str2;
  	last = (last+1) %2;  	
	if(key2_pressed ==0) RADIOSend(id, 10, s);
	else 
	{  i=0; /*initialise the string index for the while loop*/
	   while (s[i] != (char) 0)
	   {  OSSendRS232(&s[i], SERIAL1); /*RS232 send a char at a time*/
	      i++;
	   }
	}
	LCDPrintf("Sent %s\n", s);
  	break;
	
      case KEY2:
        if (key2_pressed == 0)
	{  RADIOTerm();
           key2_pressed =1;
	   LCDPrintf("\nSwitch to serial %d\n", SERIAL1);
	   OSInitRS232(SER38400, NONE, SERIAL1);
	}
	else
	{  RADIOInit();
	   key2_pressed =0;
	   LCDPrintf("\nSwitch to radio\n");
	}
        break;
    }
    if(key2_pressed ==0)
    {   if (RADIOCheck())
        { RADIORecv(&from, &num, str3);
          LCDPrintf("\nREC from %d (%d)\n", from, num);
          str3[num]=(char) 0;
	  LCDPrintf("%s\n", str3);
        }
    }
    else
    {   if(OSCheckInRS232(SERIAL1) >0) 
	{ LCDPrintf("\nREC via serial\n");
	  while(OSCheckInRS232(SERIAL1) >0)
	  {  OSRecvRS232(&rev_char, SERIAL1);
	     LCDPutChar(rev_char);
	  }
	}
    }	   
  } while(key!=KEY4);
	RADIOTerm();
return 0;
}

