/* fileName: acc.h
 * purpose: Acceleration sensor interface
 * author: Jesse Pepper <peppe-jj@ee.uwa.edu.au>
 * version: v0.00a
 * bugs:
 * notes: 
 */

/* Constants */
/* Ports used in OSGetAD */
#define cAccFBPort                     6
#define cAccLRPort                     7

/* zero values for acceleration */
#define cAccFBZero                     250
#define cAccLRZero                     300

/* Public function prototypes */

/** @param timerScale: scale of timer updates (freq = 100Hz/scale)
  * @param window: influence factor for new samples (0.1 -> 0.9*prevValue)
  */
void accInit( int timerScale, float influence );

/** @return average front/back acceleration value normalised between [-1,1]*/
float accGetFB( void );

/** @return average left/right acceleration value normalised between [-1,1]*/
float accGetLR( void );


