/*********************************************************************
 * Gyro.h - Definitions of gyro functions and globals 
 * 
 * Authors: CM Smith & NE Stamatiou
 *
 * Blizzard Project 2002
 *********************************************************************/

#ifndef GYRO_H
#define GYRO_H

#include <stdlib.h>
#include <stdio.h>
#include "eyebot.h"
#include <string.h>
#include <math.h>
#include "irtv.h"
#include <IRnokia.h>

/*Maximum number of samples logged during trials*/

#define MAX_SAMPLES 5000



/*Increment scaling factors */

#define UP_SCALE   0.8333

#define DOWN_SCALE 1.2 



/*Initial upper and lower bounds for scaling */

#define UPPER_BOUND 250

#define LOWER_BOUND -250



/*Scaling factors applied to sampled minimum and maximum*/

#define MIN_SCALE 0.9955	

#define MAX_SCALE 1.0034	



/*Resampling limits from rest-average */

#define MIN_LIMIT  0.99985

#define MAX_LIMIT  1.00015



/*Gyroscope noise reduction constants*/

#define NOISE_HIGH 1.015

#define NOISE_LOW 0.989

#define NOISE_SCALE 1.7



/*Factor to convert the int angle stored for gyro to real angle */

#define ANGLE_SCALE -0.0011    	



/*Size of moving average applied to raw data */

#define AVERAGE_SIZE  4			



/*Logging Arrays */

int graw[MAX_SAMPLES];

int gtime[MAX_SAMPLES];

int gmin[MAX_SAMPLES];

int gmax[MAX_SAMPLES];

int gaverage[MAX_SAMPLES];

int gangle[MAX_SAMPLES];

int gmaverage[MAX_SAMPLES];

int gnorm[MAX_SAMPLES];

int hardcore[MAX_SAMPLES];

int lower[MAX_SAMPLES];

int upper[MAX_SAMPLES];

int oldAngle[MAX_SAMPLES];



/*Log Gyro initialisation variables */

int ginit[10];



ServoHandle gyro_servo, gyro_servo2;

int Angle,AveAngVel1;

int SampleTime;

int gsamples;

int grest;



int lower_bound;

int upper_bound;



/* Assembly Data and routines for TPU Reading - PPWA.s*/

extern int NewDataX;

extern int NewDataY;



void accinit(void);

void accrelease(void);

int  accreadX(void);

int  accreadY(void);



/*C Gyro functions */

void InitGyro(void);

void GetGyroData(void);

double GetAngle(void);



#endif

