/*
This program receives training data for maze driving. A radio receiver should be connected to the PC.
The data is stored in binary format in the a file which name is handed over via option -d
e.g.
>./receive_train -d traindata.dat
Other generated file by this program are for checking the data. These files are:
num_dataset.h - which simply is the number of recorded datasets
in_dataset.h  - recorded input datasets
out_dataset.h - recorded output datasets
*/

#include "remote.h"
#include "eyebot.h"
#include "messaging.h"
#include <stdio.h>
#include <stdlib.h>


int main(int argc, char** argv)

{
  /* definition of output files*/
  FILE *file_num;
  FILE *file_input;
  FILE *file_output;
  int Write_Bin =0;

  int NIN_=0,NOUT_=0,datacount=0;
  FILE *file_bin;
  /* contains number of lerning patterns*/
  char *fileNameNum="num_dataset.h";
  /* contains input data*/
  char *fileNameInput="in_dataset.h";
  /* contains corresponding output data*/
  char *fileNameOutput="out_dataset.h";
  /* contains input, output, #datasets, #inputnodes and #outputnodes */
  char *fileNameBin=NULL;
  BYTE nextId, fromId;
  BYTE mes[30]; /* message buffer */
  int  len, err,i,j,stop,int_value;
  float float_value;
  int option_check=0;
  RadioIOParameters radioParams;

  for (i = 1; i < argc; i++) {

	/* Check for a switch (leading "-"). */

	if (argv[i][0] == '-') {

	    /* Use the next character to decide what to do. */

	    switch (argv[i][1]) {
                case 'h':     option_check=0;
                              break;

		case 'd':
                               Write_Bin = 1;
                               option_check=1;
                               fileNameBin = argv[++i];
                               break;
	    }
	}
    }
  if (option_check==0){
    printf("Usage: receive_train [options]\n");
    printf("Options:\n");
    printf("-help            Display this information\n");
    printf("-d <file>        Place the traindata into <file>\n");
    return 0;
  }

  datacount=0;
  /* open FIles*/
  if(Write_Bin){
    file_num = fopen(fileNameNum,"w");
    file_input = fopen(fileNameInput,"w");
    file_output = fopen(fileNameOutput,"w");
    file_bin = fopen(fileNameBin,"w");
    fwrite(&i,sizeof(int),1,file_bin);
    fwrite(&NIN_,sizeof(int),1,file_bin);
    fwrite(&NOUT_,sizeof(int),1,file_bin);
    fprintf(file_input,"double train_in_data[DATASET][NIN]={\n");
    fprintf(file_output,"double train_out_data[DATASET][NOUT] ={\n");
  }
  printf("Wireless Eye2PC\n");
  printf("---------------\n");

  RADIOGetIoctl(&radioParams);
  /* now set parameter to desired values */
  /*radioParams.speed = SER9600;
  radioParams.interface = SERIAL2;
  radioParams.debug = 0;*/
  printf("radioParams.interface=%d\n",radioParams.interface);      /* SERIAL1, SERIAL2 or SERIAL3 */
  printf("radioParams.speed=%d\n",radioParams.speed);          /* SER4800,SER9600,SER19200,SER38400,SER57600,SER115200 */
  printf("radioParams.id=%d\n",radioParams.id);             /* machine id */
  printf("radioParams.remoteOn=%d\n",radioParams.remoteOn);       /* non-zero if remote control is active */
  printf("radioParams.imageTransfer=%d\n",radioParams.imageTransfer);  /* if remote on: 0 off, 2 full, 1 reduced */
  printf("radioParams.debug=%d\n",radioParams.debug);          /* 0 off, 1..100 level of debugging spew */

  RADIOSetIoctl(radioParams);

  printf("Radio");
  err = RADIOInit();
  if (err) { printf("Error Radio Init\n"); return 1; }
    else printf("Init\n");

  nextId = 1;

  stop=0;
  while (!stop)
  { if (RADIOCheck())  /* check whether message is waiting */
    { RADIORecv(&fromId, &len, mes);  /* wait for next message */
      /* message length 1 means end of transmission*/
      if(len!=1 ){

        for(j=0;j<len;j++) {printf("%x",mes[j]);} //print the message
	printf("\n");

	NIN_ = (int)mes[0];
        NOUT_= (int)mes[1];
	if(Write_Bin){
	  fprintf(file_input,"{");
	  for(i=0;i<NIN_;i++){
	    int_value = mes2int(mes + 2 + i*sizeof(int));//the 2 is the offset because of the net paras
	    fwrite(&int_value,sizeof(int),1,file_bin);
	    fprintf(file_input,"%4.2d",int_value);
	    if(i+1!=NIN_) fprintf(file_input,",");
	  }

	  fprintf(file_input,"},\n");
	  fprintf(file_output,"{");
	  for(j=i;j<NIN_+NOUT_;j++){
	    float_value = mes2flt(mes + 2 + i*sizeof(int) +(j-i)*sizeof(float));
	    fwrite(&float_value,sizeof(float),1,file_bin);
	    fprintf(file_output,"%4.2f",float_value);
	    if(j+1!=NIN_+NOUT_)fprintf(file_output,",");
	  }
	  fprintf(file_output,"},\n");
	  datacount++;
        }
      } else stop = 1;
    }
  }
  if(Write_Bin){
    rewind(file_bin);
    fwrite(&datacount,sizeof(int),1,file_bin);
    fwrite(&NIN_,sizeof(int),1,file_bin);
    fwrite(&NOUT_,sizeof(int),1,file_bin);
    fprintf(file_input,"};\n");
    fprintf(file_output,"};\n");
    fprintf(file_num,"#define DATASET %4d	\n",datacount);
    fclose(file_bin);
    fclose(file_num);
    fclose(file_input);
    fclose(file_output);
  }
  RADIOTerm();
  return 1;
}

