/*
| -----------------------------------------------------------------------------
| Filename: hdt-plane.c
|
| Author:       Thomas Braunl   
|               Klaus Schmitt   
|               Thomas Lampart  
| Description: 
| -------
| HDT data for EyeBot MK3, UWA Sep. 1998, modified for soccerbot
| -----------------------------------------------------------------------------
*/

#define VERSION 1.1           /* User specific version nr. for information */
#define NAME "FlyeBot"        /* Unique name of the platform max. 10 chars, just info */
#define ID  2                 /* Unique platform id (int), just for inform. */

#include "hdt.h"
#include "hdt_sem.h"

/* The HDT structure */
/*-------------------*/
int     magic = 123456789;
extern HDT_entry_type HDT[];
HDT_entry_type  *hdtbase = &HDT[0];

#include "types.h"
#include "const.h"
#include "rs232.h"
#include "cam.h"
#include "librobi/librobi.h"
#include "startup.h"          /* include startup sound and image */                                                                                       
/* InfraRed REMOTE control on Servo S10 */
irtv_type irtv = {0, 11, TPU_HIGH_PRIO};                                                                       

/* SERVOs */
/* type, TPU-channel, Timer2, 20ms period, 0.7ms min, 1.7ms max */
/* here: servo 1 has TPU channel 2, and so on                   */
servo_type _rudder_ = {2, 2, TIMER2, 20000, 1000, 2000};
servo_type _elevator_ = {2, 3, TIMER2, 20000, 1000, 2000};
servo_type _aileron_ = {2, 4, TIMER2, 20000, 1000, 2000};
servo_type _throttle_ = {2, 5, TIMER2, 20000, 1000, 2000};
servo_type _camera1_ = {2, 6, TIMER2, 20000, 1000, 2000};
servo_type _camera2_ = {2, 7, TIMER2, 20000, 1000, 2000};

/* Digital compass */
compass_type compass =
	{0, /* version */
	12,  /* Servo 11, TPU channel - SCLK */
	(void*)OutBase, 5, /* P/C */
	(void*)OutBase, 6, /* CAL */
	(void*)InBase, 5}; /* PSD5 DI5 */

/* EyeBot SUMMARY */
info_type roboinfo  = {0,PLATFORM,SER115200,RTSCTS,SERIAL1,0,0,AUTOBRIGHTNESS,
                       BATTERY_ON,33,VERSION,NAME,ID};

/* waitstates = 0..13, Fast Termination = 14, External = 15 */
/* Version, ROM, RAM, LCD, IO, Parallel+Serial2/3 */
/* 16MHz - 20Mhz */
/* waitstate_type waitstates = {0,3,0,1,0,2}; */
/* 21MHz - 41Mhz */
waitstate_type waitstates = {0,3,1,2,1,2};

HDT_entry_type HDT[] =
{
    {COMPASS, COMPASS, "COMPAS", (void*)&compass},

    {SERVO,SERVO1,"RUDDER",(void *)&_rudder_},
    {SERVO,SERVO2,"ELEV",(void *)&_elevator_},
    {SERVO,SERVO3,"AILER",(void *)&_aileron_},
    {SERVO,SERVO4,"THROT",(void *)&_throttle_},
    {SERVO,SERVO5,"CAM1",(void *)&_camera1_},
    {SERVO,SERVO6,"CAM2",(void *)&_camera2_},

    {WAIT,WAIT,"WAIT",(void *)&waitstates},
    {INFO,INFO,"INFO",(void *)&roboinfo},

    {IRTV,IRTV,"IRTV",(void *)&irtv},
    {STARTMELODY,STARTMELODY,"Melody",(void *)startmelody},
    {STARTIMAGE,STARTIMAGE,"Image",(void *)&startimage},     

    {END_OF_HDT,UNKNOWN_SEMANTICS,"END",(void *)0}
};

