//## begin module%1.4%.codegen_version preserve=yes
//   Read the documentation to learn more about C++ code generator
//   versioning.
//## end module%1.4%.codegen_version

//## begin module%3D86D40302D0.cm preserve=no
//	  %X% %Q% %Z% %W%
//## end module%3D86D40302D0.cm

//## begin module%3D86D40302D0.cp preserve=no
//## end module%3D86D40302D0.cp

//## Module: PSDs%3D86D40302D0; Pseudo Package specification
//## Source file: C:\Program Files\Rational\Rose\C++\source\PSDs.h

#ifndef PSDs_h
#define PSDs_h 1

//## begin module%3D86D40302D0.additionalIncludes preserve=no
//## end module%3D86D40302D0.additionalIncludes

//## begin module%3D86D40302D0.includes preserve=yes
#include "eyebot.h"
//## end module%3D86D40302D0.includes

//## begin module%3D86D40302D0.additionalDeclarations preserve=yes
//## end module%3D86D40302D0.additionalDeclarations


//## begin PSDs%3D86D40302D0.preface preserve=yes
//## end PSDs%3D86D40302D0.preface

//## Class: PSDs%3D86D40302D0
//	/**
//	This class provides methods to access the infra-red
//	sensors. The class is designed as a singleton class.
//	This is to ensure that the initialization process is
//	executed only once as multiple initializations will
//	result in errors. So at any given time there is at most
//	one instance of the class. The method PSDs::getPSDs()
//	can be used to access that instance.
//	@author Jia L. Du
//	 */
//## Category: <Top Level>
//## Persistence: Transient
//## Cardinality/Multiplicity: n



class PSDs
{
  //## begin PSDs%3D86D40302D0.initialDeclarations preserve=yes
  //## end PSDs%3D86D40302D0.initialDeclarations

  public:

    //## Other Operations (specified)
      //## Operation: initialize%3D902A18000A
      //	/**
      //	Initializes the sensors for usage. Should automatically be called by the
      //  constructor. But as the EyeSim simulator is not able to execute RoBIOS
      //  library functions in class constructors, we have declared this method as
      //  public and need to call this method manually in main
      //	@return true if successful
      //	*/
      bool initialize ();

      //## Operation: getPSDs%3D9AA1F70078
      //	/**
      //	This method is used to get the instance of this
      //	singleton class
      //	@return A pointer to the instance
      //	 */
      static PSDs* getPSDs ();

      //## Operation: readLeft%3D9029830334
      //	/**
      //	@return The distance to the next object as read by the
      //	left infra-red sensor (in meter)
      //	*/
      double readLeft ();

      //## Operation: readRight%3D9029B1023A
      //	/**
      //	@return The distance to the next object as read by the
      //	right infra-red sensor (in meter)
      //	*/
      double readRight ();

      //## Operation: readFront%3D9029B603B6
      //	/**
      //	@return The distance to the next object as read by the
      //	front infra-red sensor (in meter)
      //	*/
      double readFront ();

    // Additional Public Declarations
      //## begin PSDs%3D86D40302D0.public preserve=yes
      //## end PSDs%3D86D40302D0.public

  protected:
    //## Constructors (generated)
      PSDs();

    //## Destructor (generated)
      ~PSDs();


    //## Other Operations (specified)
      //## Operation: release%3D902A210122
      //	/**
      //	Releases the sensors after usage. Is automatically called by the
      //  destructor
      //	@return true if successful
      //	 */
      bool release ();

    // Additional Protected Declarations
      //## begin PSDs%3D86D40302D0.protected preserve=yes
      //## end PSDs%3D86D40302D0.protected

  private:
    // Additional Private Declarations
      //## begin PSDs%3D86D40302D0.private preserve=yes
      //## end PSDs%3D86D40302D0.private

  private: //## implementation
    // Data Members for Class Attributes

      //## Attribute: aPSD%3D9AA1E00366
      //	/**
      //	The single instance that exists of this class
      //	@see PSD::getPSD()
      //	*/
      //## begin PSDs::aPSD%3D9AA1E00366.attr preserve=no  private: static PSDs {U} 
      static PSDs aPSD;
      //## end PSDs::aPSD%3D9AA1E00366.attr

      //## Attribute: leftPSDHandle%3D9AA1B50096
      //	/**
      //	Used internally to access the left infra-red sensor
      //	*/
      //## begin PSDs::leftPSDHandle%3D9AA1B50096.attr preserve=no  private: PSDHandle {U} 
      PSDHandle leftPSDHandle;
      //## end PSDs::leftPSDHandle%3D9AA1B50096.attr

      //## Attribute: rightPSDHandle%3D9AA1CC03A2
      //	/**
      //	Used internally to access the right infra-red sensor
      //	*/
      //## begin PSDs::rightPSDHandle%3D9AA1CC03A2.attr preserve=no  private: PSDHandle {U} 
      PSDHandle rightPSDHandle;
      //## end PSDs::rightPSDHandle%3D9AA1CC03A2.attr

      //## Attribute: frontPSDHandle%3D9AA1CD0064
      //	/**
      //	Used internally to access the front infra-red sensor
      //	*/
      //## begin PSDs::frontPSDHandle%3D9AA1CD0064.attr preserve=no  private: PSDHandle {U} 
      PSDHandle frontPSDHandle;
      //## end PSDs::frontPSDHandle%3D9AA1CD0064.attr

    // Additional Implementation Declarations
      //## begin PSDs%3D86D40302D0.implementation preserve=yes
      //## end PSDs%3D86D40302D0.implementation

};

//## begin PSDs%3D86D40302D0.postscript preserve=yes
//## end PSDs%3D86D40302D0.postscript

// Class PSDs 

//## begin module%3D86D40302D0.epilog preserve=yes
//## end module%3D86D40302D0.epilog


#endif
