|****************************************************************************
|*																			*
|*	cogito Gesellschaft fuer Elektronikentwicklung mbH						*
|*		info@cogito.de		http://www.cogito.de/							*
|*	  																		*
|*		gnu C startup code for mc68xxx single-board-computer				*
|*																			*
|*				File			: mc68xxx.startup.s							*
|*				Author			: Frank Sautter								*
|*				First Byte		: 14.07.93									*
|*				Latest Change	: 12.06.96									*
|*																			*
|****************************************************************************

			.include		"mc683xx.inc"
			.include		"start_s.inc"

			.text

|****************************************************************************
|*	Setup the environement
|****************************************************************************

	        .data
crt0start:
			.align 2
_environ:	.long 0
			.align	2
			.text
			.global _main
			.global _exit

			.global __stack
			.global __bss_start
			.global __end
			.global crt0start

|****************************************************************************
|*	Let the show begin
|****************************************************************************
_start:
			/* set up stack pointer */	
			moveal  #__stack, sp
			
			/* set up initial stack frame */
			link	a6, #-8

|****************************************************************************
|*	zero bss section
|****************************************************************************

			movel	#__bss_start, d1
			movel	#__end, d0
			cmpl	d0,d1
			jbeq	2f
			movl	d1,a0
			subl	d1,d0
1:
			clrb	(a0)+
			dbra	d0,1b
			clrw	d0
			subql	#1,d0
			jbcc	1b
2:

|****************************************************************************
|*	call main
|****************************************************************************

			pea		0
			pea		_environ
			pea		sp@(4)
			pea		0
			jsr		main
			movel	d0, sp@-
			
|*			jsr		exit
			rts
