STARTUP(crt0.o)
OUTPUT_ARCH(m68k)
SEARCH_DIR(.)
INPUT(idp.o)
__DYNAMIC  =  0;

/*
 * Setup the memory map of the MC68ec0x0 Board (IDP)
 * stack grows down from high memory. This works for
 * both the rom68k and the mon68k monitors.
 *
 * The memory map look like this:
 * +--------------------+ <- low memory
 * | .text              |
 * |        _etext      |
 * |        ctor list   | the ctor and dtor lists are for
 * |        dtor list   | C++ support
 * +--------------------+
 * | .data              | initialized data goes here
 * |        _edata      |
 * +--------------------+
 * | .bss               |
 * |        __bss_start | start of bss, cleared by crt0
 * |        _end        | start of heap, used by sbrk()
 * +--------------------+
 * .                    .
 * .                    .
 * .                    .
 * |        __stack     | top of stack
 * +--------------------+
 */

/*
 * When the IDP is not remapped (see rom68k's MP command in the
 * "M68EC0x0IDP Users Manual", the first 64K bytes are reserved;
 * Otherwise the first 256K bytes are reserved.
 *
 * The following memory map describes a unmapped IDP w/2MB RAM.
 */

MEMORY
{
  ram	: ORIGIN = 0x00010000, LENGTH = 2M-64K
  rom0	: ORIGIN = 0x00800000, LENGTH = 1M
  rom1	: ORIGIN = 0x00900000, LENGTH = 1M
}

__stack = 1M - 8;

/*
 * stick everything in ram (of course)
 */
SECTIONS
{
  .text :
  {
    *(.text)
    _etext = .;
    __CTOR_LIST__ = .;
    LONG((__CTOR_END__ - __CTOR_LIST__) / 4 - 2)
    *(.ctors)
    LONG(0)
    __CTOR_END__ = .;
    __DTOR_LIST__ = .;
    LONG((__DTOR_END__ - __DTOR_LIST__) / 4 - 2)
    *(.dtors)
    LONG(0)
    __DTOR_END__ = .;
    *(.lit)
    *(.shdata)
  } > ram
  .shbss SIZEOF(.text) + ADDR(.text) :
  {
    *(.shbss)
  } > ram
  .data :
  {
    *(.data)
    _edata = .;
  } > ram
  .bss SIZEOF(.data) + ADDR(.data) :
  {
    __bss_start = ALIGN(0x8);
    *(.bss)
    *(COMMON)
    _end = ALIGN(0x8);
    __end = ALIGN(0x8);
  } > ram
  .stab . (NOLOAD) :
  {
    [ .stab ]
  }
  .stabstr . (NOLOAD) :
  {
    [ .stabstr ]
  }
}
