|****************************************************************************
|*																			*
|*	cogito Gesellschaft fuer Elektronikentwicklung mbH						*
|*		info@cogito.de		http://www.cogito.de/							*
|*	  																		*
|*		gnu C startup code for mc68xxx single-board-computer				*
|*																			*
|*				File			: romboot.s									*
|*				Author			: Frank Sautter								*
|*				First Byte		: 14.07.93									*
|*				Latest Change	: 18.06.96									*
|*																			*
|****************************************************************************

			.include		"mc683xx.inc"
			.include		"start_s.inc"

			.text

|****************************************************************************
|*	256 Systemvektoren														*
|****************************************************************************

Start:
			bra.w		init_33x			| 0 Zum Initstart springen
			.long		init_33x-Start		| 1 Programm Counter after Reset
			.long		notinst				| 2 Bus Error
			.long		notinst				| 3 Adress Error
			.long		ill_instr			| 4 Illegal Instruction
			.long		notinst				| 5 Zero Divide not installed
			.long		notinst				| 6 CHK Instruction not installed
			.long		notinst				| 7 TRAPV Instruction
			.long		notinst				| 8 Priveledge Voilation not installed
			.long		notinst				| 9 Trace
			.long		notinst				| 10 Line A Emulator
			.long		notinst				| 11 Line F Emulator
			.long		notinst				| 12 reserved
			.long		notinst				| 13 reserved
			.long		notinst				| 14 Format Error not installed
			.long		notinst				| 15 Uninitialized Interrupt not installed

			.long		notinst				| 16 reserved
			.long		notinst				| 17 reserved
			.long		notinst				| 18 reserved
			.long		notinst				| 19 reserved
			.long		notinst				| 20 reserved
			.long		notinst				| 21 reserved
			.long		notinst				| 22 reserved
			.long		notinst				| 23 reserved
			.long		notinst				| 24 Superious Interrupt
			.long		notinst				| 25 Level 1 Interrupt Autovector
			.long		notinst				| 26 Level 2 Interrupt Autovector
			.long		notinst				| 27 Level 3 Interrupt Autovector
			.long		notinst				| 28 Level 4 Interrupt Autovector
			.long		notinst				| 29 Level 5 Interrupt Autovector
			.long		notinst				| 30 Level 6 Interrupt Autovector
			.long		notinst				| 31 Level 7 Interrupt Autovector

			.long		notinst				| 32 TRAP #0
			.long		notinst				| 33 TRAP #1
			.long		notinst				| 34 TRAP #2
			.long		notinst				| 35 TRAP #3
			.long		notinst				| 36 TRAP #4
			.long		notinst				| 37 TRAP #5
			.long		notinst				| 38 TRAP #6
			.long		notinst				| 39 TRAP #7
			.long		notinst				| 40 TRAP #8
			.long		notinst				| 41 TRAP #9
			.long		notinst				| 42 TRAP #10
			.long		notinst				| 43 TRAP #11
			.long		notinst				| 44 TRAP #12
			.long		notinst				| 45 TRAP #13
			.long		notinst				| 46 TRAP #14
			.long		notinst				| 47 TRAP #15

			.long		notinst				| 48 reserved
			.long		notinst				| 49 reserved
			.long		notinst				| 50 reserved
			.long		notinst				| 51 reserved
			.long		notinst				| 52 reserved
			.long		notinst				| 53 reserved
			.long		notinst				| 54 reserved
			.long		notinst				| 55 reserved
			.long		notinst				| 56 reserved
			.long		notinst				| 57 reserved
			.long		notinst				| 58 reserved
			.long		notinst				| 59 reserved
			.long		notinst				| 60 reserved
			.long		notinst				| 61 reserved
			.long		notinst				| 62 reserved
			.long		notinst				| 63 reserved

			.long		systimer			| 64 User Defined 100Hz Systemtimer
			.long		notinst				| 65 User Defined
			.long		notinst				| 66 User Defined
			.long		notinst				| 67 User Defined
			.long		notinst				| 68 User Defined
			.long		notinst				| 69 User Defined
			.long		notinst				| 70 User Defined
			.long		notinst				| 71 User Defined
			.long		notinst				| 72 User Defined
			.long		notinst				| 73 User Defined
			.long		notinst				| 74 User Defined
			.long		notinst				| 75 User Defined
			.long		notinst				| 76 User Defined
			.long		notinst				| 77 User Defined
			.long		notinst				| 78 User Defined
			.long		notinst				| 79 User Defined

			.long		notinst				| 80 User Defined
			.long		notinst				| 81 User Defined
			.long		notinst				| 82 User Defined
			.long		notinst				| 83 User Defined
			.long		notinst				| 84 User Defined
			.long		notinst				| 85 User Defined
			.long		notinst				| 86 User Defined
			.long		notinst				| 87 User Defined
			.long		notinst				| 88 User Defined
			.long		notinst				| 89 User Defined
			.long		notinst				| 90 User Defined
			.long		notinst				| 91 User Defined
			.long		notinst				| 92 User Defined
			.long		notinst				| 93 User Defined
			.long		notinst				| 94 User Defined
			.long		notinst				| 95 User Defined

			.long		notinst				| 96 User Defined
			.long		notinst				| 97 User Defined
			.long		notinst				| 98 User Defined
			.long		notinst				| 99 User Defined
			.long		notinst				| 100 User Defined
			.long		notinst				| 101 User Defined
			.long		notinst				| 102 User Defined
			.long		notinst				| 103 User Defined
			.long		notinst				| 104 User Defined
			.long		notinst				| 105 User Defined
			.long		notinst				| 106 User Defined
			.long		notinst				| 107 User Defined
			.long		notinst				| 108 User Defined
			.long		notinst				| 109 User Defined
			.long		notinst				| 110 User Defined
			.long		notinst				| 111 User Defined

			.long		notinst				| 112 User Defined
			.long		notinst				| 113 User Defined
			.long		notinst				| 114 User Defined
			.long		notinst				| 115 User Defined
			.long		notinst				| 116 User Defined
			.long		notinst				| 117 User Defined
			.long		notinst				| 118 User Defined
			.long		notinst				| 119 User Defined
			.long		notinst				| 120 User Defined
			.long		notinst				| 121 User Defined
			.long		notinst				| 122 User Defined
			.long		notinst				| 123 User Defined
			.long		notinst				| 124 User Defined
			.long		notinst				| 125 User Defined
			.long		notinst				| 126 User Defined
			.long		notinst				| 127 User Defined

			.long		notinst				| 128 User Defined
			.long		notinst				| 129 User Defined
			.long		notinst				| 130 User Defined
			.long		notinst				| 131 User Defined
			.long		notinst				| 132 User Defined
			.long		notinst				| 133 User Defined
			.long		notinst				| 134 User Defined
			.long		notinst				| 135 User Defined
			.long		notinst				| 136 User Defined
			.long		notinst				| 137 User Defined
			.long		notinst				| 138 User Defined
			.long		notinst				| 139 User Defined
			.long		notinst				| 140 User Defined
			.long		notinst				| 141 User Defined
			.long		notinst				| 142 User Defined
			.long		notinst				| 143 User Defined

			.long		notinst				| 144 User Defined
			.long		notinst				| 145 User Defined
			.long		notinst				| 146 User Defined
			.long		notinst				| 147 User Defined
			.long		notinst				| 148 User Defined
			.long		notinst				| 149 User Defined
			.long		notinst				| 150 User Defined
			.long		notinst				| 151 User Defined
			.long		notinst				| 152 User Defined
			.long		notinst				| 153 User Defined
			.long		notinst				| 154 User Defined
			.long		notinst				| 155 User Defined
			.long		notinst				| 156 User Defined
			.long		notinst				| 157 User Defined
			.long		notinst				| 158 User Defined
			.long		notinst				| 159 User Defined

			.long		notinst				| 160 User Defined
			.long		notinst				| 161 User Defined
			.long		notinst				| 162 User Defined
			.long		notinst				| 163 User Defined
			.long		notinst				| 164 User Defined
			.long		notinst				| 165 User Defined
			.long		notinst				| 166 User Defined
			.long		notinst				| 167 User Defined
			.long		notinst				| 168 User Defined
			.long		notinst				| 169 User Defined
			.long		notinst				| 170 User Defined
			.long		notinst				| 171 User Defined
			.long		notinst				| 172 User Defined
			.long		notinst				| 173 User Defined
			.long		notinst				| 174 User Defined
			.long		notinst				| 175 User Defined

			.long		notinst				| 176 User Defined
			.long		notinst				| 177 User Defined
			.long		notinst				| 178 User Defined
			.long		notinst				| 179 User Defined
			.long		notinst				| 180 User Defined
			.long		notinst				| 181 User Defined
			.long		notinst				| 182 User Defined
			.long		notinst				| 183 User Defined
			.long		notinst				| 184 User Defined
			.long		notinst				| 185 User Defined
			.long		notinst				| 186 User Defined
			.long		notinst				| 187 User Defined
			.long		notinst				| 188 User Defined
			.long		notinst				| 189 User Defined
			.long		notinst				| 190 User Defined
			.long		notinst				| 191 User Defined

			.long		notinst				| 192 User Defined
			.long		notinst				| 193 User Defined
			.long		notinst				| 194 User Defined
			.long		notinst				| 195 User Defined
			.long		notinst				| 196 User Defined
			.long		notinst				| 197 User Defined
			.long		notinst				| 198 User Defined
			.long		notinst				| 199 User Defined
			.long		notinst				| 200 User Defined
			.long		notinst				| 201 User Defined
			.long		notinst				| 202 User Defined
			.long		notinst				| 203 User Defined
			.long		notinst				| 204 User Defined
			.long		notinst				| 205 User Defined
			.long		notinst				| 206 User Defined
			.long		notinst				| 207 User Defined

			.long		notinst				| 208 User Defined
			.long		notinst				| 209 User Defined
			.long		notinst				| 210 User Defined
			.long		notinst				| 211 User Defined
			.long		notinst				| 212 User Defined
			.long		notinst				| 213 User Defined
			.long		notinst				| 214 User Defined
			.long		notinst				| 215 User Defined
			.long		notinst				| 216 User Defined
			.long		notinst				| 217 User Defined
			.long		notinst				| 218 User Defined
			.long		notinst				| 219 User Defined
			.long		notinst				| 220 User Defined
			.long		notinst				| 221 User Defined
			.long		notinst				| 222 User Defined
			.long		notinst				| 223 User Defined

			.long		notinst				| 224 User Defined
			.long		notinst				| 225 User Defined
			.long		notinst				| 226 User Defined
			.long		notinst				| 227 User Defined
			.long		notinst				| 228 User Defined
			.long		notinst				| 229 User Defined
			.long		notinst				| 230 User Defined
			.long		notinst				| 231 User Defined
			.long		notinst				| 232 User Defined
			.long		notinst				| 233 User Defined
			.long		notinst				| 234 User Defined
			.long		notinst				| 235 User Defined
			.long		notinst				| 236 User Defined
			.long		notinst				| 237 User Defined
			.long		notinst				| 238 User Defined
			.long		notinst				| 239 User Defined

			.long		notinst				| 240 User Defined
			.long		notinst				| 241 User Defined
			.long		notinst				| 242 User Defined
			.long		notinst				| 243 User Defined
			.long		notinst				| 244 User Defined
			.long		notinst				| 245 User Defined
			.long		notinst				| 246 User Defined
			.long		notinst				| 247 User Defined
			.long		notinst				| 248 User Defined
			.long		notinst				| 249 User Defined
			.long		notinst				| 250 User Defined
			.long		notinst				| 251 User Defined
			.long		notinst				| 252 User Defined
			.long		notinst				| 253 User Defined
			.long		notinst				| 254 User Defined
			.long		notinst				| 255 User Defined


|****************************************************************************
|*	Code for return on non initialized exeptions							*
|****************************************************************************

notinst:	rte								| Return from not installed vectors


|****************************************************************************
|*	Code for illegal exception processing									*
|****************************************************************************

ill_instr:	add.l		#2,2(sp)			| Increase PC
			rte	


|****************************************************************************
|*	This is where the show begins										*
|****************************************************************************

init_33x:	lea.l		_end+0x400,a0
			move.l		a0,sp
			move.l		a0,usp

			move.w		#0b1110000001001111,sim_mcr		| set mcr
			move.b		#0b00000100,sim_sypcr			| no Watchdog
			move.w		#0x7f00,sim_syncr				| set CPU to 16MHz

			moveq.l		#0,d7							| d7 holds rom and ram configuration

			move.w		sim_cspar0,d0
			and.w		#0b1111111111110011,d0
			or.w		#0b0000000000001000,d0			| check for 8 bit wide ram
			move.w		d0,sim_cspar0

			move.w		#0x8007,sim_csbar0				| /cs0 with 1M blocksize, base 0x800000
			move.w		#0b0111100000110000,sim_csor0	| SIM-CSOR0 read/write

			move.w		#0x55aa,0x800000				| check for 16 bit
			cmp.w		#0x55aa,0x800000
			bne			.cs0onlo						| the ram has no connection to a0
			move.w		#0xff00,0x800000
			cmp.w		#0xff00,0x800000
			bne			.cs0onlo						| the ram has no connection to a0

			bset.l		#0,d7							| set 8 bit ram mode
			bra			.setcs


.cs0onlo:	move.w		sim_cspar0,d0
			or.w		#0b0000000000111100,d0			| check for 16 bit wide ram
			move.w		d0,sim_cspar0

			move.w		#0x8007,sim_csbar0				| /cs0 with 1M blocksize, base 0x800000
			move.w		#0b0011100000110000,sim_csor0	| sim_csor0 read/write lower byte

			move.b		#0x11,0x800001					| check if ram on /cs0 is on d0-d7
			cmp.b		#0x11,0x800001
			bne			.cs0onup

			bset.l		#1,d7							| ram on /cs0 is on d0-d7
			move.w		#0b0001100000110000,sim_csor0	| sim_csor0 deactivate
			bra			.cs1onlo


.cs0onup:	move.w		#0b0101100000110000,sim_csor0	| sim_csor0 read/write upper byte

			move.b		#0x22,0x800000					| check if ram on /cs0 is on d8-d15
			cmp.b		#0x22,0x800000
			bne			.noram

			bset.l		#2,d7							| ram on /cs0 is on d8-d15
			move.w		#0b0001100000110000,sim_csor0	| sim_csor0 deactivate


.cs1onlo:	move.w		#0x8007,sim_csbar1				| /cs1 with 1M blocksize, base 0x800000
			move.w		#0b0011100000110000,sim_csor1	| sim_csor1 read/write lower byte

			move.b		#0x44,0x800001					| check if ram on /cs1 is on d0-d7
			cmp.b		#0x44,0x800001
			bne			.cs1onup

			bset.l		#3,d7							| ram on /cs1 is on d0-d7
			move.w		#0b0001100000110000,sim_csor1	| sim_csor1 deactivate
			bra			.setcs

.cs1onup:	move.w		#0b0101100000110000,sim_csor1	| sim_csor1 read/write upper byte

			move.b		#0x88,0x800000					| check if ram on /cs1 is on d8-d15
			cmp.b		#0x88,0x800000
			bne			.noram

			bset.l		#4,d7							| ram on /cs1 is on d8-d15
			move.w		#0b0001100000110000,sim_csor1	| sim_csor1 deactivate


.setcs:		cmp.w		#0b00001,d7						| 8 bit wide ram ?
			bne			.setlh							| na

			move.w		#0x0007,sim_csbar7				| /cs0 with 1M blocksize, base 0x000000
			move.w		#0b0111001110110000,sim_csor0	| sim_csor0 write only
			bra			testend

.setlh:		cmp.w		#0b01010,d7
			bne			.sethl

			move.w		sim_cspar1,d0
			and.w		#0b1111111111111100,d0
			or.w		#0b0000000000000001,d0
			move.w		d0,sim_cspar1					| use /cs6 as a19

			move.w		#0x0007,sim_csbar0				| sim_csbar0 1M blocksize ram base 0x000
			move.w		#0b0011000000110000,sim_csor0	| sim_csor0 lower byte, write only
			move.w		#0x0007,sim_csbar1				| sim_csbar1 1M-Blocksize RAM Base 0x000
			move.w		#0b0101000000110000,sim_csor1	| sim_csor1 upper byte, write only
			bra			testend

.sethl:		cmp.w		#0b10100,d7
			bne			.noram

			move.w		sim_cspar1,d0
			and.w		#0b1111111111111100,d0
			or.w		#0b0000000000000001,d0
			move.w		d0,sim_cspar1					| use /cs6 as a19

			move.w		#0x0007,sim_csbar0				| sim_csbar0 1M blocksize ram base 0x000
			move.w		#0b0101000000110000,sim_csor0	| sim_csor0 upper byte, write only
			move.w		#0x0007,sim_csbar1				| sim_csbar1 1M-Blocksize RAM Base 0x000
			move.w		#0b0011000000110000,sim_csor1	| sim_csor1 lower byte, write only
			bra			testend

.noram:		bra			.noram

testend:	lea			Start,a0						| is text segment compiled for start address 0 ? 
			lea			_edata,a1						| yes: copy complete rom to ram
			tst.l		a0
			beq.s		remap

			lea			remapped-Start,a1				| no:  copy only vector table and startup code to ram

remap:		lea			0x0,a0							| copy rom to ram
.copyloop:	move.w		(a0),(a0)+
			cmp.l		a0,a1
			bne.s		.copyloop


			btst		#0,d7
			beq			.ram8							| ram is 8 bit wide
			or.w		#0b0001100000000000,sim_csor1	| enable reading from ram on /cs1
.ram8:		or.w		#0b0001100000000000,sim_csor0	| enable reading from ram on /cs0
	
			move.w		#0xc007,sim_csbarbt				| set rom base address and size
		
			jmp			remapped						| absolute jump
			nop

remapped:	dc.w		bgnd							| stop for background mode debugger

			move.b		#0x00,sim_pfpar
			move.l		#_end+0x400,rambot			| set rambot
			move.l		#0x040000,ramtop				| set ramtop
														| here should be a ramtest

			move.l		#16777000,cpuspeed				| 16MHz cpu clock

			move.w		#0x0052,sim_pitr				| 100Hz periodic timer
			move.w		#0x0240,sim_picr				| vector 64
			lea			0x000000,a0						| system vektors are now in ram area
			movec.l		a0,vbr
			
			btst.b		#6,sim_rsr						| last reset was power up
			beq.s		.nopowup
			move.l		#0,sysclock						| initialize systemtimer
.nopowup:

			move.w		#0x2100,sr						| enabling interrupts
		
			cmp.l		#0x04111967,automagic
			bne			.noauto
			move.w		#600,d0
			move.w		#100,d1
|			bsr			beep
			move.l		autoadress,a0
			jsr			(a0)

.noauto:
        	jsr			crt0start

__Exit:		movec.l		vbr,a0							| get vector base register
			move.l		4(a0),a0						| get reset vektor
			jmp			(a0)							| and go.....
			

|****************************************************************************
|*	set autostart															*
|****************************************************************************

set_auto:	move.l		a0,autoadress					| store address
			move.l		#0x04111967,automagic			| set magic
			rts


|****************************************************************************
|*	delete autostart														*
|****************************************************************************

kill_auto:	clr.l		automagic						| delete magic
			rts


|****************************************************************************
|*	start software															*
|****************************************************************************

prgstart:	jmp			(a0)


|****************************************************************************
|*	serve watchdog															*
|****************************************************************************

watchdog:	move.b		#0x55,sim_swsr
			move.b		#0xaa,sim_swsr
			rts


|****************************************************************************
|*	1/100 sec timer interrupt												*
|****************************************************************************

systimer:	addq.l		#1,sysclock			|increment systemtimer
			rte


|****************************************************************************
|*	bss segement															*
|****************************************************************************

			.bss
			
sysclock:	ds.l		1
rambot:		ds.l		1
ramtop:		ds.l		1
cpuspeed:	ds.l		1
autoadress:	ds.l		1
automagic:	ds.l		1
transstart:	ds.l		1
warmmagic:	ds.l		1

        	.end

|****************************************************************************
