//## begin module%1.4%.codegen_version preserve=yes
//   Read the documentation to learn more about C++ code generator
//   versioning.
//## end module%1.4%.codegen_version

//## begin module%3D86D43B008C.cm preserve=no
//	  %X% %Q% %Z% %W%
//## end module%3D86D43B008C.cm

//## begin module%3D86D43B008C.cp preserve=no
//## end module%3D86D43B008C.cp

//## Module: Radio%3D86D43B008C; Pseudo Package specification
//## Source file: C:\Program Files\Rational\Rose\C++\source\Radio.h

#ifndef Radio_h
#define Radio_h 1

//## begin module%3D86D43B008C.additionalIncludes preserve=no
//## end module%3D86D43B008C.additionalIncludes

//## begin module%3D86D43B008C.includes preserve=yes
#include "eyebot.h"
#include "Version.h"
//## end module%3D86D43B008C.includes

//## begin module%3D86D43B008C.additionalDeclarations preserve=yes
//## end module%3D86D43B008C.additionalDeclarations


//## begin Radio%3D86D43B008C.preface preserve=yes
//## end Radio%3D86D43B008C.preface

//## Class: Radio%3D86D43B008C
//	/**
//	This class provides methods to use the radio
//	communication. The class is designed as a singleton
//	class. This is to ensure that the radio initialization
//	process is only executed once as multiple
//	initializations will result in errors. So at any given
//	time there is at most one instance of the class. The
//	method Radio::getRadio() is used to access that instance.
//	@author Jia L. Du
//	 */
//## Category: <Top Level>
//## Persistence: Transient
//## Cardinality/Multiplicity: n



class Radio
{
  //## begin Radio%3D86D43B008C.initialDeclarations preserve=yes
  //## end Radio%3D86D43B008C.initialDeclarations

  public:

    //## Other Operations (specified)
      //## Operation: initialize%3D9025D502A8
      //	/**
      //	Initializes the radio for usage. Should automatically be called by the
      //  constructor. But as the EyeSim simulator is not able to execute RoBIOS
      //  library functions in class constructors, we have declared this method as
      //  public and need to call this method manually in main
      //	@return true if successful
      //	*/
      bool initialize ();
      
      //## Operation: getRadio%3D9AA29D0032
      //	/**
      //	This method is used to get the instance of this
      //	singleton class
      //	@return A pointer to the instance
      //	 */
      static Radio* getRadio ();

      //## Operation: send%3D9025140078
      //	/**
      //	Sends a message
      //	@param id The id of the destination robot
      //	@param byteCount The message length
      //	@param message A pointer to the message
      //	@return true if successful
      //	*/
      bool send (BYTE id, int byteCount, BYTE* message);

      //## Operation: checkForMessages%3D9025560212
      //	/**
      //	Checks if there are any messages in the buffer
      //	@return The number of messages in the buffer
      //	*/
      int checkForMessages ();

      //## Operation: receive%3D9025690280
      //	/**
      //	Gets a message from the message buffer. If there are no
      //	messages in the buffer the calling thread will be
      //	blocked until a message is received. It is suggested to
      //	call Radio::checkForMessages() before calling this method
      //  The message buffer must have room for MSGMAXLEN (defined in eyebot.h) bytes
      //	@param id The id of the sending robot is stored here
      //	@param receivedBytes The message length
      //	@param message A pointer to the message
      //	*/
      void receive (BYTE* id, int* receivedBytes, BYTE* message);

      //## Operation: getActiveRobots%3D90256F0050
      //	/**
      //	Returns an array that indicates which robots in the
      //	vicinity are active and can be contacted. The value at
      //	an array position is true if that robot is active. The
      //	array index equals the id of that robot
      //	@param active Array of bools with a minimum length of MAXEYE (defined in eyebot.h)
      //	*/
      void getActiveRobots (bool active[]);

      //## Operation: getMyID%3D9BEB190276
      //	/**
      //	Returns the ID of this robot
      //	@return Own ID
      //	*/
      int getMyID ();

    // Additional Public Declarations
      //## begin Radio%3D86D43B008C.public preserve=yes
      //	/**
      //	Returns the ID of the robot that is currently the master
      //	@return ID of current master
      //	*/
      int getCurrentMasterID ();
      //## end Radio%3D86D43B008C.public

  protected:
    //## Constructors (generated)
      Radio();

    //## Destructor (generated)
      ~Radio();


    //## Other Operations (specified)

      //## Operation: terminate%3D9025E50078
      //	/**
      //	Terminates the radio communication. Is automatically called by the
      //  destructor
      //	@return true if successful
      //	 */
      bool terminate ();

    // Additional Protected Declarations
      //## begin Radio%3D86D43B008C.protected preserve=yes
      //## end Radio%3D86D43B008C.protected

  private:
    // Additional Private Declarations
      //## begin Radio%3D86D43B008C.private preserve=yes
      //## end Radio%3D86D43B008C.private

  private: //## implementation
    // Data Members for Class Attributes

      //## Attribute: aRadio%3D9AA2BD0154
      //	/**
      //	The single instance that exists of this class
      //	@see Radio::getRadio()
      //	*/
      //## begin Radio::aRadio%3D9AA2BD0154.attr preserve=no  private: static Radio {U} 
      static Radio radios[NUMBER_OF_ROBOTS];
      //## end Radio::aRadio%3D9AA2BD0154.attr

    // Additional Implementation Declarations
      //## begin Radio%3D86D43B008C.implementation preserve=yes
      //## end Radio%3D86D43B008C.implementation

};

//## begin Radio%3D86D43B008C.postscript preserve=yes
//## end Radio%3D86D43B008C.postscript

// Class Radio 

//## begin module%3D86D43B008C.epilog preserve=yes
//## end module%3D86D43B008C.epilog


#endif
