#include <fstream>
#include <stdio.h>
#include <stdlib.h>
#include <time.h>
#include <string.h>
#include <math.h>
#define PI 3.1416
#define DEBUG 0

//  Generate a random world of uniform size
//
//  World generated conform to the following criteria:
//
//  - Ball lies at the centre of the world
//  - Robot starting position is randomly place along a circle
//    surrounding the ball.
//
//  Libor Masek, 17-01-03

int main(int argc, char** argv)
{
	int size, radius, diam, sign, o;
	double angle;
	int ballx, bally; //starting position of ball
	int x,y;
	int botx, boty, boto; //starting position of the bot, x posn, y posn and orientation

	if(argc != 4) {
		printf("Usage: WorldGen <world filename> <square size> <distance from centre>\n");
		return 0;
	}

	FILE *ofs, *botpos;

	srand(time(NULL));


	size = atoi(argv[2]);
	radius = atoi(argv[3]);

	if (DEBUG) printf("Generating world size %d x %d\n", size, size);

	botpos = fopen("coord.txt", "w");
	ofs = fopen(argv[1], "w");

	if(!ofs) {
		printf("Error opening file %s for writing\n", argv[1]);
		return 0;
	}

	//calculate the ball postion, just half the size of the box
	ballx = size /2;
	bally = size /2;

	/*calculate the positon of the robi, must be the specificed
	distance away from the ball */

	diam = radius *2;
	sign = rand()%2;
		
	if(sign==0) sign=-1;
	else sign = 1;

	angle = (2.0*PI*rand()/RAND_MAX);
	
	x = (int) (radius * cos(angle));
	y = (int) (radius * sin(angle));
	
	botx = size/2 + x;
	boty = size/2 + y;

	//choose random orientation
	o = rand() % 4;

		switch(o) {
			case 0:
				boto = 90;// Facing up
				break;
			case 1:
				boto = 0; // Right
				break;
			case 2:
				boto = 180; // Left
				break;
			case 3:
				boto = -90; // Facing down
				break;
		}
	

	if (DEBUG) printf("BOTX %i\n", x);
	if (DEBUG) printf("BOTY %i\n", y);
	if (DEBUG) printf("ORIE %i\n",boto);
	if (DEBUG) printf("Coord %d %d\n",botx, boty);

	//  Write out the world file
	fprintf(ofs, ";World file automatically generated by WorldGen\n");
	fprintf(ofs, "\n");
	fprintf(ofs, "width %i\n", size);
	fprintf(ofs, "height %i\n", size);
	fprintf(ofs, "\n");
	fprintf(ofs, ";outer rectangle\n");
	fprintf(ofs, "\n");
	fprintf(ofs, "0 0 0 %i\n", size);
	fprintf(ofs, "0 0 %i 0\n", size);
	fprintf(ofs, "0 %i %i %i\n", size, size, size);
	fprintf(ofs, "%i 0 %i %i\n", size, size, size);
	fprintf(ofs, "\n");
	fprintf(ofs, ";the ball\n");
	fprintf(ofs, "\n");
	fprintf(ofs, "object %i %i\n", ballx, bally);
	fprintf(ofs, "\n");
	fprintf(ofs, ";starting position of robi\n");
	fprintf(ofs, "\n");
	fprintf(ofs, "position %i %i %i\n",botx, boty, boto);
	fprintf(botpos, "%d %d %d\n",botx, boty, boto);

	fclose(ofs);
	fclose(botpos);

}
