#include <time.h>
#include "lisp_parser.h"


// int cmpfunc(const void *, const void *);

int cmpfunc( const void *a,  const void *b)
{
	float i1,i2;
	
	i1 = *(float *)a;
	i2 = *(float *)b;
	
	if ( i1<i2) return -1;
	
	else if (i1==i2) return 0;
	else return 1;
}

void check_space(FILE *file, char *c)
{
	if(isspace(*c) )
	{
		while(isspace(*c))
		{
			*c = getc(file);
		}
	}
}

int isPossibleTerminal(char c)
{
	if(c =='t' || c=='m' || c=='p' || c=='M' || c == 'o' || c=='l' || c=='h') return true;
	else return false;
}

int isPossibleFunction(char c)
{
	if(c =='I' || c=='P' || c=='W') return true;
	else return false;
}

int get_closing_bracket(FILE *file, char *c)
{
	if(*c != ')')
	{
		while(*c!=')')
		{
			*c = getc(file);
#ifdef DEBUG
			printf("get_closing_bracket: char read %c \n", *c);
#endif
			if(!isspace(*c) && *c!=')' ) return false;
		}
	}
	return true;
}



int get_symbol(FILE *file, char *c, int BUFF_LEN, Sym_Type sym_flag, int *symbol)
{
	char *buffer;
	int i = 0;

	buffer = (char *)malloc(sizeof(char) * BUFF_LEN);

	buffer[i] = *c;
#ifdef DEBUG
	printf("get_symbol: first char is %c, %c\n", *c, buffer[i] );
#endif
	while(!isspace(*c) )
	{
		*c = getc(file);

		if(!isspace(*c) )
		{
			i++;
			buffer[i] = *c;
		}
		if(i-1 > BUFF_LEN )
		{
#ifdef DEBUG
		printf("get_symbol: buffer overflow\n");
#endif
		return false;
		}

		//if sym_flag == false, then check for function
	}
#ifdef DEBUG
	printf("get_symbol: buffer contains %s\n", buffer);

#endif

	if(sym_flag==term)
	{
		if(!strncmp(buffer, "turn-left",9))
		{
			*symbol = turnleft;
#ifdef DEBUG
			printf("get_symbol: turn-left %d found!\n", *symbol);
#endif
		}
		else if(!strncmp(buffer, "turn-right", 10))
		{
			*symbol = turnright;

#ifdef DEBUG
			printf("get_symbol: turn-right %d found!\n", *symbol);
#endif
		}
		else if(!strncmp(buffer, "move-forward", 12))
		{
			*symbol = moveforward;
#ifdef DEBUG
			printf("get_symbol: move-forward %d found!\n", *symbol);
#endif
		}
		else if(!strncmp(buffer, "move-backward", 13))
		{
			*symbol = movebackward;
#ifdef DEBUG
			printf("get_symbol: move-backward %d found!\n", *symbol);
#endif
		}
		else if(!strncmp(buffer, "psd-front", 9))
		{
			*symbol = psdfront;
#ifdef DEBUG
			printf("get_symbol: psd-front %d found!\n", *symbol);
#endif
		}

		else if(!strncmp(buffer, "psd-back", 8))
		{
			*symbol = psdback;
#ifdef DEBUG
			printf("get_symbol: psd-back %d found!\n", *symbol);
#endif
		}

		else if(!strncmp(buffer, "psd-left", 8))
		{
			*symbol = psdleft;
#ifdef DEBUG
			printf("get_symbol: psd-left %d found!\n", *symbol);
#endif
		}

		else if(!strncmp(buffer, "psd-right", 9))
		{
			*symbol = psdright;
#ifdef DEBUG
			printf("get_symbol: psd-right %d found!\n", *symbol);
#endif
		}

		else if(!strncmp(buffer, "msd", 3))
		{
			*symbol = msd;
#ifdef DEBUG
			printf("get_symbol: msd %d found!\n", *symbol);
#endif
		}

		else if(!strncmp(buffer, "obj-size", 8))
		{
			*symbol = objsize;
#ifdef DEBUG
			printf("get_symbol: obj-size %d found!\n", *symbol);
#endif
		}

		else if(!strncmp(buffer, "obj-pos", 7))
		{
			*symbol = objpos;
#ifdef DEBUG
			printf("get_symbol: obj-pos %d found!\n", *symbol);
#endif
		}

		else if(!strncmp(buffer, "low",3))
		{
			*symbol = low;
#ifdef DEBUG
			printf("get_symbol: low %d found!\n", *symbol);
#endif
		}

		else if(!strncmp(buffer, "high",4))
		{
			*symbol = high;
#ifdef DEBUG
			printf("get_symbol: high %d found!\n", *symbol);
#endif
		}

		else
		{
#ifdef DEBUG
			printf("get_symbol: terminal syntax error\n");
#endif
			return false;
		}
	}
	else if(sym_flag == func)
	{
		if(!strncmp(buffer, "PROGN2",6))
		{
			*symbol = PROGN2;
#ifdef DEBUG
			printf("get_symbol: PROGN2 %d found!\n", *symbol);
#endif
		}

		else if(!strncmp(buffer, "IF_LESS",5))
		{
			*symbol = IF_LESS;
#ifdef DEBUG
			printf("get_symbol: IF_LESS %d found!\n", *symbol);
#endif
		}

		else if(!strncmp(buffer, "WHILE_LESS",9))
		{
			*symbol = WHILE_LESS;
#ifdef DEBUG
			printf("get_symbol: WHILE_LESS %d found!\n", *symbol);
#endif
		}



		else
		{
#ifdef DEBUG
			printf("get_symbol: func syntax error\n");
#endif
			return false;
		}

	}
	else
	{
#ifdef DEBUG
		printf("get_symbol: sym_flag error\n");
#endif
	}
	return true;
}

void printPopulation(char *string, Tree *t, int population)
{
	int i;
	char filename[100];
	for ( i =0; i<population; i++)
	{
		sprintf(filename, "%s%d.lsp", string, i);
		printTree(t[i], filename);
	}
}

