#include <stdio.h>
#include <stdlib.h>
#include "tree.h"
#include "constgp.h"
#include "gp.h"

#define MIN(a,b)	((a)<(b)?(a):(b))

void Copy_Node (Node *n1, Node n2) {
	int i;

	if (n2==NULL) { printf("Error! Copying a NULL node!!\n"); exit(1); }
	*n1 = initNode(n2->sym_t, n2->symbol, n2->n_children);

	if (*n1 == NULL) { printf("Error creating node!\n"); exit(1); }
	for (i=0;i<n2->n_children;i++) 	Copy_Node (&(*n1)->children[i], n2->children[i]);
}

int main() {
	Tree t1, t2, t3;
	Genetic gp1, gp2;
	int compare;
	int i;
	Node n1, temp1, temp2;

	srand(time(NULL));

	t1 = initTree();
	t2 = initTree();
	t3 = initTree();

	add2Tree(t1, (symtype) WHILE_LESS);
	add2Tree(t1, (symtype) low);
	add2Tree(t1, (symtype) objsize);
	add2Tree(t1, (symtype) IF_LESS);
	add2Tree(t1, (symtype) low);
	add2Tree(t1, (symtype) objsize);
	add2Tree(t1, (symtype) turnright);
	add2Tree(t1, (symtype) turnright);

	add2Tree(t2, (symtype) WHILE_LESS);
	add2Tree(t2, (symtype) low);
	add2Tree(t2, (symtype) objsize);
	add2Tree(t2, (symtype) turnleft);

	CrossOver (t1, t2);

	printTree(t1, "runme.lsp");
	printf("\n");
	printTree(t2, "runme.lsp");
	printf("\n");


	return 0;

}


