//## begin module%1.4%.codegen_version preserve=yes
//   Read the documentation to learn more about C++ code generator
//   versioning.
//## end module%1.4%.codegen_version

//## begin module%3D86D35000AA.cm preserve=no
//	  %X% %Q% %Z% %W%
//## end module%3D86D35000AA.cm

//## begin module%3D86D35000AA.cp preserve=no
//## end module%3D86D35000AA.cp

//## Module: Commander%3D86D35000AA; Pseudo Package body
//## Source file: C:\Program Files\Rational\Rose\C++\source\Commander.cpp

//## begin module%3D86D35000AA.additionalIncludes preserve=no
//## end module%3D86D35000AA.additionalIncludes

//## begin module%3D86D35000AA.includes preserve=yes
//## end module%3D86D35000AA.includes

// Commander
#include "Commander.h"
//## begin module%3D86D35000AA.additionalDeclarations preserve=yes
//## end module%3D86D35000AA.additionalDeclarations


// Class Commander

//## begin Commander::EXPLORING%3D9AB34601FE.attr preserve=no  private: static int {UC} 0
const int Commander::EXPLORING = 0;
//## end Commander::EXPLORING%3D9AB34601FE.attr

//## begin Commander::PUSHING%3D9AB37502E4.attr preserve=no  private: static int {UC} 1
const int Commander::PUSHING = 1;
//## end Commander::PUSHING%3D9AB37502E4.attr

//## begin Commander::AVOIDING%3D9AB375038E.attr preserve=no  private: static int {UC} 2
const int Commander::AVOIDING = 2;
//## end Commander::AVOIDING%3D9AB375038E.attr

//## begin Commander::COMMUNICATING%3D9AB37601FE.attr preserve=no  private: static int {UC} 3
const int Commander::COMMUNICATING = 3;
//## end Commander::COMMUNICATING%3D9AB37601FE.attr


Commander::Commander ()
      : state(-1)
  ,Thread("commander", 128*1024, MAX_PRI, 1)
{
}

void Commander::initialize(void)
{
  mes[OSMachineID()] = this;
  explorer.initialize();
  pusher.initialize();
  avoider.initialize();
  communicator.initialize();
}

// Additional Declarations
  //## begin Commander%3D86D35000AA.declarations preserve=yes

  Commander* Commander::mes[NUMBER_OF_ROBOTS];

  void Commander::run(void)
  {
    LCDPrintf("Commander started\n");
    int result = explorer.activate();
    state = EXPLORING;

    while(1)
    {
      if (state == EXPLORING)
      {
        if (result == explorer.CUBE_DETECTED)
        {
          result = pusher.activate();
          state = PUSHING;
        }
        else if (result == explorer.ROBOT_DETECTED)
        {
          result = communicator.activate();
          state = COMMUNICATING;
        }
        else if (result == explorer.DRIVE_STALLED)
        {
          result = communicator.activate();
          state = COMMUNICATING;
        }
      }
      if (state == PUSHING)
      {
        if (result == pusher.ARRIVED)
        {
          result = avoider.activate();
          state = AVOIDING;
        }
        else if (result == pusher.CUBE_LOST)
        {
          result = explorer.activate();
          state = EXPLORING;
        }
        else if (result == pusher.DRIVE_STALLED)
        {
          result = avoider.activate();
          state = AVOIDING;
        }
      }
      if (state == COMMUNICATING)
      {
        if (result == communicator.DONE)
        {
          result = avoider.activate();
          state = AVOIDING;
        }
        else if (result == communicator.NOT_ONE_RESPONSE)
        {
          result = avoider.activate();
          state = AVOIDING;
        }
        else if (result == communicator.ROBOT_LEFT)
        {
          result = avoider.activate();
          state = AVOIDING;
        }
      }
      if (state == AVOIDING)
      {
        result = explorer.activate();
        state = EXPLORING;
      }
    }
  }

  void Commander::doSleep(int hundredthSeconds)
  {
  	sleep(hundredthSeconds);
  }
  void Commander::doReschedule(void)
  {
  	reschedule();
  }

  bool Commander::spawn ()
  {
    threadControlBlock = OSSpawn(name, staticRun, stackSize, priority, OSMachineID()*10+id);
    if (threadControlBlock)
      return true;
    else
      return false;
  }

  void Commander::staticRun ()
  {
    mes[OSMachineID()]->run();
  }


  //## end Commander%3D86D35000AA.declarations

//## begin module%3D86D35000AA.epilog preserve=yes
//## end module%3D86D35000AA.epilog
